% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3D.R
\name{plot3DWithProj}
\alias{plot3DWithProj}
\title{3D plot of PC scores with projections on coordinate planes}
\usage{
plot3DWithProj(
  pc,
  dims = c(1, 2, 3),
  plotProj = TRUE,
  grid = TRUE,
  col = 1,
  ff = 0.5,
  theta = -45,
  phi = 25
)
}
\arguments{
\item{pc}{An \code{rppca} object}

\item{dims}{\code{integer} \code{vector}, which PCs to plot, defauts to 1:3}

\item{plotProj}{\code{logical}, whether to plot the projections}

\item{grid}{\code{logical}, wheter to plot grids}

\item{col}{the dot colours, integer or string, scalar or vector}

\item{ff}{\code{numeric}, offset for projection (proportion of the orthogonal axis's range)}

\item{theta, phi}{polar coordinates in degrees. \code{theta} rotates round the
vertical axis. \code{phi} rotates round the horizontal axis.}
}
\value{
nothing
}
\description{
3D plot of PC scores with projections on coordinate planes
}
\examples{
ped <- pedigree(pedMeta$fid,
pedMeta$mid,
pedMeta$id
)
pc <- rppca(ped)
plot3DWithProj(pc, col=as.numeric(factor(pedMeta$population)))
}
