% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangeFiles-methods.R
\name{selectShpFiles}
\alias{selectShpFiles}
\title{Select (recursively) shape files}
\usage{
selectShpFiles(dir, ...)
}
\arguments{
\item{dir}{character string specifying the directory containing .shp files.}

\item{\dots}{currently ignored}
}
\value{
Either a \code{\link{data.frame}} or a character vector is returned.
}
\description{
Returns the file path to all \sQuote{.shp} polygons in a directory.
}
\note{
The function uses \code{\link[maptools]{getinfo.shape}} to only select
              polygon files (aka type 5).
}
\examples{
f = system.file(package="rangeMapper", "extdata", "wrens", "vector")
res = selectShpFiles(f, ogr = TRUE, polygons.only = TRUE)
head(res)

}

