% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_subset.R
\name{rmap_save_subset}
\alias{rmap_save_subset}
\alias{rmap_save_subset,rmapConnection,character-method}
\title{Save subsets}
\usage{
rmap_save_subset(con, dst, ...)

\S4method{rmap_save_subset}{rmapConnection,character}(con, dst, ...)
}
\arguments{
\item{con}{a \code{rangeMapper} connection made with  \code{\link[=rmap_connect]{rmap_connect()}}.}

\item{dst}{the name of the new subset table.}

\item{...}{SQL \code{WHERE} calls, see Details.}
}
\value{
TRUE when the database view is written to the project file, FALSE otherwise.
}
\description{
\code{rmap_save_subset} creates subsets based on the canvas properties and/or the properties of one or
several \code{bio} tables.
}
\details{
Subsets are defined using \code{table_name = "CONDITION"} where \code{CONDITION} can be any \code{SQL} \code{WHERE} call
defined for the given table.
Here is a summary of the \href{https://www.sqlite.org/lang_expr.html}{SQL operators} relevant in this context:\tabular{ll}{
   Operator \tab Description \cr
   \code{=} or \code{==} or \code{IS}  or \verb{! =} or \verb{<>} or \verb{IS NOT} \tab Equals or Non-equals. \cr
   \code{>} or \code{<}  or \code{>=} or \code{<=} \tab Greater (Less) than (or equal). \cr
   \code{IN} or \verb{NOT IN} \tab multiple given values e.g. \verb{a IN (a,b,c,x,y)}. \cr
   \code{BETWEEN} \tab Between a given range (given values included) e.g. \verb{BETWEEN 1 and 10}. \cr
   \code{LIKE} \tab Pattern search e.g. \verb{LIKE "\%keyword\%"}. \code{LIKE} is \strong{case insensitive}. \cr
   \code{GLOB} \tab Similar to \code{LIKE} but uses the Unix wildcards (\code{*},\verb{?},\verb{[]}). e.g. \verb{[a-zA-Z0-9] matches any single alphanumeric. }GLOB` is \strong{case sensitive}. \cr
}
}
\examples{
require(rangeMapper)
con = rmap_connect()
data(wrens)
rmap_add_ranges(con, x = wrens, ID = 'sci_name')
rmap_prepare(con, 'hex', cellsize = 500)
rmap_add_bio(con, wrens, 'sci_name')
rmap_save_map(con) 
rmap_save_subset(con,'s1', 
   species_richness = 'species_richness > 10', 
   wrens = 'body_mass > 19 AND clutch_size > 3')

dbDisconnect(con)

}
