% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_prepare.R
\name{rmap_prepare}
\alias{rmap_prepare}
\alias{rmap_prepare,rmapConnection,character,numeric,missing-method}
\alias{rmap_prepare,rmapConnection,character,numeric,numeric-method}
\title{Define a canvas and process ranges}
\usage{
rmap_prepare(con, grid_type, cellsize, chunksize, ...)

\S4method{rmap_prepare}{rmapConnection,character,numeric,missing}(con, grid_type, cellsize, chunksize, ...)

\S4method{rmap_prepare}{rmapConnection,character,numeric,numeric}(con, grid_type = "hex", cellsize, chunksize = 1/10, ...)
}
\arguments{
\item{con}{a \code{rangeMapper} connection made with  \code{\link[=rmap_connect]{rmap_connect()}}.}

\item{grid_type}{character "hex" (default) or "square", see \code{\link[sf:st_make_grid]{sf::st_make_grid()}}.}

\item{cellsize}{target cellsize, see \code{\link[sf:st_make_grid]{sf::st_make_grid()}}.}

\item{chunksize}{parallel processing chunk size expressed as proportion from the range size. Default to 1/10.}

\item{...}{further arguments passed to \code{\link[sf:st_make_grid]{sf::st_make_grid()}}}
}
\value{
TRUE when the table is written to the project file, FALSE otherwise.
}
\description{
\code{rmap_prepare} updates a 'raw' unprepared project to a ready to use project.
\code{rmap_prepare} creates the project's canvas and assign each range to its corresponding canvas cells by
performing a spatial intersection between the ranges and the canvas. The canvas is a regular grid
of squares or hexagons.
}
\details{
Because \code{rmap_prepare} can be potentially time consuming it can be run in parallel using the
support provided by the \code{future} package.
\code{future} allows parallel processing on a variety of systems including high performance computing environments.
For details see \code{\link[future:plan]{future::plan()}}.
Additionally, you can keep track of of the computations using \code{\link[progressr:handlers]{progressr::handlers()}}.
}
\examples{

# IN-MEMORY PROJECT
require(rangeMapper)
wrens = read_wrens()
con = rmap_connect() 
rmap_add_ranges(con, wrens, 'sci_name')
rmap_prepare(con, 'hex', cellsize=500)
dbDisconnect(con)

\dontrun{

# PROJECT PREPARED IN PARALLEL

require(future) 
require(progressr)
plan(multisession, workers = 2)
handlers(global = TRUE)

Path = tempfile() 
con = rmap_connect(Path)
rmap_add_ranges(con, wrens, 'sci_name')

rmap_prepare(con, 'hex', cellsize=200, chunksize = 0.1)

dbDisconnect(con)
plan(sequential)
}

}
\references{
Birch, C. P., Oom, S. P., & Beecham, J. A. (2007). Rectangular and hexagonal grids used for observation,
experiment and simulation in ecology. Ecological modelling, 206(3-4), 347-359.
}
\seealso{
\code{\link[=rmap_add_ranges]{rmap_add_ranges()}}
}
