% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{keep_big_polygons}
\alias{keep_big_polygons}
\title{Exclude small polygons from SpatialPolygons object}
\usage{
keep_big_polygons(polygons, threshold_size)
}
\arguments{
\item{polygons}{SpatialPolygonsDataFrame object.}

\item{threshold_size}{(numeric) threshold value of area to determine whether
polygons are big or not. Areas must be according to projection of \code{polygons}.}
}
\value{
A SpatialPolygonsDataFrame with polygons with areas above
\code{threshold_size}.
}
\description{
Exclude small polygons from SpatialPolygons object
}
\examples{
data("spdf_range", package = "rangemap")
sp::plot(spdf_range)

big_polys <- keep_big_polygons(polygons = spdf_range, threshold_size = 0.2)
sp::plot(big_polys)
}
