% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canonicalize.R
\name{canonicalize}
\alias{canonicalize}
\title{Compute a canonical representation of an interval order}
\usage{
canonicalize(intervals)
}
\arguments{
\item{intervals}{data frame (see \link{generateIntervals} for
the required format)}
}
\value{
a data frame in the same format as the input
}
\description{
This functions generates a set of intervals with distinct endpoints such that
running any of the functions in this package on the return value gives the
same answer as running those functions on the input.
}
\details{
See section 3.1 of Rising (2021).
}
\examples{
left <- c(0, 0, 0, 1, 2)
right <- c(0, 1, 2, 2, 2)
intervals <- data.frame(left = left, right = right)
toMatrix(intervals)
toMatrix(canonicalize(intervals))
}
\references{
Rising, Justin (2021).  \emph{Uncertainty in Ranking}.  arXiv:2107.03459.
}
