% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_mb.R
\name{ci_mb}
\alias{ci_mb}
\title{Calculate confidence intervals for Mallows-Binomial parameters based on the nonparametric bootstrap}
\usage{
ci_mb(
  Pi,
  X,
  M,
  interval = 0.9,
  nsamples = 100,
  all = FALSE,
  method = c("ASTAR", "ASTAR_LP", "Greedy", "GreedyLocal", "FV"),
  localsearch = 0
)
}
\arguments{
\item{Pi}{Matrix of partial or complete rankings, one row per ranking.}

\item{X}{Matrix of ratings, one row per judge and one column per object.}

\item{M}{Numeric specifying maximum (=worst quality) integer rating.}

\item{interval}{Numeric between 0 and 1 specifying the confidence interval (e.g., .90 indicates a 90\% confidence interval). Defaults to 0.90.}

\item{nsamples}{Numeric indicating desired number of bootstrap samples to be used when calculating confidence intervals. Defaults to 100.}

\item{all}{Boolean indicating if estimated parameters from all bootstrap samples should be returned. Defaults to FALSE.}

\item{method}{String indicating which estimation method to use when estimating parameters.}

\item{localsearch}{Numeric for use with the Greedy and FV methods; ignored otherwise. See documentation of those estimation functions for details. Defaults to 0, indicating no local search.}
}
\value{
List with elements ci (matrix of confidence intervals for Mallows-Binomial parameters; always returned), bootstrap_pi0 (matrix of bootstrap consensus rankings; returned only if all=TRUE), and bootstrap_ptheta (matrix of bootstrap estimates of (p,theta); returned only if all=TRUE).
}
\description{
This function calculates confidence intervals for parameters in a Mallows-Binomial model using the nonparametric bootstrap.
}
\examples{
Pi <- matrix(c(1,2,3,4,2,1,NA,NA),byrow=TRUE,nrow=2)
X <- matrix(c(0,1,2,3,1,2,2,5),byrow=TRUE,nrow=2)
ci_mb(Pi=Pi,X=X,M=5,method="FV",interval=0.95,nsamples=20,all=TRUE,localsearch=1)
 
}
