% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapSolved.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,RapSolved,RapSolved-method}
\alias{plot,RapSolved,missing-method}
\alias{plot,RapSolved,numeric-method}
\title{Plot object}
\usage{
\S4method{plot}{RapSolved,numeric}(x, y, basemap = "none",
  pu.color.palette = c("#e5f5f9", "#00441b", "#FFFF00", "#FF0000"),
  alpha = ifelse(basemap == "none", 1, 0.7), grayscale = FALSE,
  main = NULL, force.reset = FALSE)

\S4method{plot}{RapSolved,missing}(x, y, basemap = "none",
  pu.color.palette = c("PuBu", "#FFFF00", "#FF0000"), alpha = ifelse(basemap
  == "none", 1, 0.7), grayscale = FALSE, main = NULL, force.reset = FALSE)

\S4method{plot}{RapSolved,RapSolved}(x, y, i = NULL, j = i,
  basemap = "none", pu.color.palette = ifelse(is.null(i), c("RdYlBu",
  "#FFFF00", "#FF0000"), "Accent"), alpha = ifelse(basemap == "none", 1, 0.7),
  grayscale = FALSE, main = NULL, force.reset = FALSE)
}
\arguments{
\item{x}{\code{RapSolved} object.}

\item{y}{\code{NULL} to plot selection frequencies. \code{numeric} to plot the i'th solution, or 0 to plot the best solution. \code{RapSolved} object to plot differences in solutions between objects. Defaults to \code{ULL}.}

\item{basemap}{\code{character} object indicating the type of basemap to use (see \code{link{basemap}}). Use either 'none', 'roadmap', 'mobile', 'satellite', 'terrain', 'hybrid', 'mapmaker-roadmap', 'mapmaker-hybrid'. Defaults to 'none'.}

\item{pu.color.palette}{\code{character} name of colors or color palette (\code{\link[RColorBrewer]{brewer.pal}}) to indicate planning unit statuses. Defaults to \code{c('grey30', 'green', 'yellow', 'black', 'gray80', 'red', 'orange')}.}

\item{alpha}{\code{numeric} value to indicate how transparent the planning unit colors should be.}

\item{grayscale}{\code{logical} should the basemap be gray-scaled?}

\item{main}{\code{character} title for the plot. Defaults to \code{NULL} and a default title is used.}

\item{force.reset}{\code{logical} if basemap data has been cached, should it be re-downloaded?}

\item{i}{\code{NULL} to plot selection frequencies. \code{numeric} to plot the i'th solution, or 0 to plot the best solution. Only used when \code{y} is a \code{RapSolved} object. Defaults to \code{NULL}.}

\item{j}{\code{NULL} to plot selection frequencies. \code{numeric} to plot the i'th solution, or 0 to plot the best solution. Only used when \code{y} is a \code{RapSolved} object. Defaults to \code{j}.}
}
\description{
This function plots the solutions contained in \code{RapSolved} objects. It can be used to show a single solution, or the the selection frequencies of planning
units contained in a single \code{RapSolved} object. Additionally, two \code{RapSolved} objects can be supplied to plot the differences between them.
}
\examples{
# load data
data(sim_rs)
## simulated species examples
# plot selection frequencies
plot(sim_rs)
# plot best solution
plot(sim_rs, 0)
# plot second solution
plot(sim_rs, 2)
# plot different between best and second solutions
plot(sim_rs, sim_rs, 0 ,2)
}
\seealso{
\code{\link{RapSolved}}.
}

