% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GurobiOpts.R
\name{GurobiOpts}
\alias{GurobiOpts}
\title{Create GurobiOpts object}
\usage{
GurobiOpts(Threads = 1L, MIPGap = 0.1, Method = 0L, Presolve = 2L,
  TimeLimit = NA_integer_, NumberSolutions = 1L,
  MultipleSolutionsMethod = "benders.cuts")
}
\arguments{
\item{Threads}{\code{integer} number of cores to use for processing. Defaults to 1L.}

\item{MIPGap}{\code{numeric} MIP gap specifying minimum solution quality. Defaults to 0.1.}

\item{Method}{\code{integer} Algorithm to use for solving model. Defaults to 0L.}

\item{Presolve}{\code{integer} code for level of computation in presolve (lp_solve parameter). Defaults to 2.}

\item{TimeLimit}{\code{integer} number of seconds to allow for solving. Defaults to NA_integer_, and so a time limit is not imposed.}

\item{NumberSolutions}{\code{integer} number of solutions to generate. Defaults to 1L.}

\item{MultipleSolutionsMethod}{\code{character} name of method to obtain multiple solutions \code{NumberSolutions} > 1. Available options are 'benders.cuts' and 'solution.pool'. Defaults to 'benders.cuts'. Note that the \code{rgurobi} package must be to use the 'solution.pool' method.}
}
\value{
\code{GurobiOpts} object
}
\description{
This function creates a new GurobiOpts object.
}
\examples{
# create GurobiOpts object using default parameters
GurobiOpts(Threads=1L, MIPGap=0.1, Method=0L, 
	Presolve=2L, TimeLimit=NA_integer_, NumberSolutions=1L)
}
\seealso{
\code{\link{GurobiOpts-class}}.
}
