% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapSolved.R
\name{space.held}
\alias{space.held}
\alias{space.held.RapSolved}
\title{Extract attribute space held for a solution}
\usage{
space.held(x, y, species, space)

\method{space.held}{RapSolved}(x, y = 0, species = NULL, space = NULL)
}
\arguments{
\item{x}{\code{\link{RapResults}} or \code{\link{RapSolved}} object.}

\item{y}{\code{NULL} to return all values, \code{integer} 0 to return values for best solution, \code{integer} value greater than 0 for \code{y}'th solution value.}

\item{species}{\code{NULL} for all species or \code{integer} indicating species.}

\item{space}{\code{NULL} for all spaces or \code{integer} indicating a specific space.}
}
\value{
code{matrix} object.
}
\description{
This function returns the attribute space held for each species in a solution.
}
\examples{
data(sim_rs)
# space held (\\\%) for each species in best solution
space.held(sim_rs, 0)
# space held (\\\%) for each species in second solution
space.held(sim_rs, 2)
# space held (\\\%) for each species in each solution
space.held(sim_rs)
}
\seealso{
\code{\link{RapResults}}, \code{\link{RapSolved}}.
}
