% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2PolySet.R
\name{convert2PolySet}
\alias{convert2PolySet}
\alias{convert2PolySet.SpatialPolygonsDataFrame}
\alias{convert2PolySet.SpatialPolygons}
\alias{convert2PolySet.sf}
\title{Convert object to PolySet data}
\usage{
convert2PolySet(x, n_preallocate)

\method{convert2PolySet}{SpatialPolygonsDataFrame}(x, n_preallocate = 10000L)

\method{convert2PolySet}{SpatialPolygons}(x, n_preallocate = 10000L)

\method{convert2PolySet}{sf}(x, n_preallocate = 10000L)
}
\arguments{
\item{x}{\code{\link[sf:sf]{sf::st_sf()}}, \code{\link[sp:SpatialPolygons]{sp::SpatialPolygons()}} or
\code{\link[sp:SpatialPolygons]{sp::SpatialPolygonsDataFrame()}} object.}

\item{n_preallocate}{\code{integer} How much memory should be preallocated
for processing? Ideally, this number should equal the number of vertices
in the \code{\link[sp:SpatialPolygons]{sp::SpatialPolygons()}} object. If data processing is
taking too long consider increasing this value.}
}
\value{
\code{PBSmapping::PolySet()} object.
}
\description{
This function converts \code{\link[sf:sf]{sf::st_sf()}} and
\code{\link[sp:SpatialPolygons]{sp::SpatialPolygonsDataFrame()}} objects to
\code{PBSmapping::PolySet()} objects.
}
\note{
Be aware that this function is designed to be as fast as possible, but
as a result it depends on C++ code and if used inappropriately this
function will crash R.
}
\examples{
\dontrun{
# generate sf object
sim_pus <- sim.pus(225L)

# convert to PolySet
x <- convert2PolySet(sim_pus)
}
}
\seealso{
For a slower, more stable equivalent see
\code{maptools::SpatialPolygons2PolySet}.
}
