% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\docType{methods}
\name{swapVariables}
\alias{swapVariables}
\alias{swapVariables,ratioOfQsprays,numeric,numeric-method}
\title{Swap variables}
\usage{
\S4method{swapVariables}{ratioOfQsprays,numeric,numeric}(x, i, j)
}
\arguments{
\item{x}{a \code{ratioOfQsprays} object}

\item{i, j}{indices of the variables to be swapped}
}
\value{
A \code{ratioOfQsprays} object.
}
\description{
Swap two variables of a \code{ratioOfQsprays}.
}
\examples{
library(ratioOfQsprays)
f <- function(x, y, z) {
  (x^2 + 5*y + z - 1) / (x + 1)
}
x <- qlone(1)
y <- qlone(2)
z <- qlone(3)
R <- f(x, y, z)
S <- swapVariables(R, 2, 3)
S == f(x, z, y) # should be TRUE
}
