% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_object}
\alias{csg_object}
\title{Constructive Solid Geometry Object}
\usage{
csg_object(
  object,
  x = 0,
  y = 0,
  z = 0,
  radius = 1,
  material = diffuse(),
  angle = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  velocity = c(0, 0, 0),
  flipped = FALSE,
  scale = c(1, 1, 1)
)
}
\arguments{
\item{object}{Object created with CSG interface.}

\item{x}{Default `0`. x-offset of the center of the object.}

\item{y}{Default `0`. y-offset of the center of the object.}

\item{z}{Default `0`. z-offset of the center of the object.}

\item{radius}{Default `1`. Radius of the sphere..}

\item{material}{Default  \code{\link{diffuse}}. The material, called from one of the material 
functions \code{\link{diffuse}}, \code{\link{metal}}, or \code{\link{dielectric}}.}

\item{angle}{Default `c(0, 0, 0)`. Angle of rotation around the x, y, and z axes, applied in the order specified in `order_rotation`.}

\item{order_rotation}{Default `c(1, 2, 3)`. The order to apply the rotations, referring to "x", "y", and "z".}

\item{velocity}{Default `c(0, 0, 0)`. Velocity of the sphere, used for motion blur.}

\item{flipped}{Default `FALSE`. Whether to flip the normals.}

\item{scale}{Default `c(1, 1, 1)`. Scale transformation in the x, y, and z directions. If this is a single value,
number, the object will be scaled uniformly.
Note: emissive objects may not currently function correctly when scaled.}
}
\value{
Single row of a tibble describing the sphere in the scene.
}
\description{
This object takes an object constructed using the `csg_*` functions. The object is drawn using
ray marching/sphere tracing.
}
\details{
Note: For dielectric objects, any other objects not included in the CSG object and
nested inside will be ignored.
}
\examples{
\donttest{
#We will combine these three objects:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\%
  add_object(csg_object(csg_box(), material=glossy(color="red"))) \%>\% 
  add_object(csg_object(csg_sphere(radius=0.707), material=glossy(color="green"))) \%>\% 
  add_object(csg_object(csg_group(list(csg_cylinder(start=c(-1,0,0), end=c(1,0,0), radius=0.4),
                   csg_cylinder(start=c(0,-1,0), end=c(0,1,0), radius=0.4),
                   csg_cylinder(start=c(0,0,-1), end=c(0,0,1), radius=0.4))),
                   material=glossy(color="blue"))) \%>\% 
  add_object(sphere(y=5,x=3,radius=1,material=light(intensity=30))) \%>\%
  render_scene(clamp_value=10, fov=15,lookfrom=c(5,5,10))

#Standard CSG sphere + box - crossed cylinder combination:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\%
  add_object(csg_object(csg_combine(
    csg_combine(
      csg_box(),
      csg_sphere(radius=0.707),
      operation="intersection"),
    csg_group(list(csg_cylinder(start=c(-1,0,0), end=c(1,0,0), radius=0.4),
                   csg_cylinder(start=c(0,-1,0), end=c(0,1,0), radius=0.4),
                   csg_cylinder(start=c(0,0,-1), end=c(0,0,1), radius=0.4))),
    operation="subtract"),
    material=glossy(color="red"))) \%>\%
  add_object(sphere(y=5,x=3,radius=1,material=light(intensity=30))) \%>\%
  render_scene(clamp_value=10, fov=10,lookfrom=c(5,5,10))
  
#Blend them all instead:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\%
  add_object(csg_object(csg_combine(
    csg_combine(
      csg_box(),
      csg_sphere(radius=0.707),
      operation="blend"),
    csg_group(list(csg_cylinder(start=c(-1,0,0), end=c(1,0,0), radius=0.4),
                   csg_cylinder(start=c(0,-1,0), end=c(0,1,0), radius=0.4),
                   csg_cylinder(start=c(0,0,-1), end=c(0,0,1), radius=0.4))),
    operation="blend"),
    material=glossy(color="purple"))) \%>\%
  add_object(sphere(y=5,x=3,radius=1,material=light(intensity=30))) \%>\%
  render_scene(clamp_value=10, fov=15,lookfrom=c(5,5,10))
}
}
