% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_object.R
\name{add_object}
\alias{add_object}
\title{Add Object}
\usage{
add_object(scene, objects)
}
\arguments{
\item{scene}{Tibble of pre-existing object locations and properties.}

\item{objects}{A tibble row or collection of rows representing each object.}
}
\value{
Tibble of object locations and properties.
}
\description{
Add Object
}
\examples{
#Generate the ground and add some objects
scene = generate_ground(depth=-0.5,material = diffuse(checkercolor="blue")) \%>\%
  add_object(cube(x=0.7,
                  material=diffuse(noise=5,noisecolor="purple",color="black",noisephase=45),
                  angle=c(0,-30,0))) \%>\%
  add_object(sphere(x=-0.7,radius=0.5,material=metal(color="gold")))
\donttest{
render_scene(scene,parallel=TRUE)
}
}
