% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{sphere}
\alias{sphere}
\title{Sphere Object}
\usage{
sphere(
  x = 0,
  y = 0,
  z = 0,
  radius = 1,
  material = diffuse(),
  angle = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  flipped = FALSE,
  scale = c(1, 1, 1)
)
}
\arguments{
\item{x}{Default `0`. x-coordinate of the center of the sphere.}

\item{y}{Default `0`. y-coordinate of the center of the sphere.}

\item{z}{Default `0`. z-coordinate of the center of the sphere.}

\item{radius}{Default `1`. Radius of the sphere.}

\item{material}{Default  \code{\link{diffuse}}. The material, called from one of the material 
functions \code{\link{diffuse}}, \code{\link{metal}}, or \code{\link{dielectric}}.}

\item{angle}{Default `c(0, 0, 0)`. Angle of rotation around the x, y, and z axes, applied in the order specified in `order_rotation`.}

\item{order_rotation}{Default `c(1, 2, 3)`. The order to apply the rotations, referring to "x", "y", and "z".}

\item{flipped}{Default `FALSE`. Whether to flip the normals.}

\item{scale}{Default `c(1, 1, 1)`. Scale transformation in the x, y, and z directions. If this is a single value,
number, the object will be scaled uniformly.
Note: emissive objects may not currently function correctly when scaled.}
}
\value{
Single row of a tibble describing the sphere in the scene.
}
\description{
Sphere Object
}
\examples{
#Generate a sphere in the cornell box.
\donttest{
generate_cornell() \%>\%
  add_object(sphere(x = 555/2, y = 555/2, z = 555/2, radius = 100)) \%>\%
  render_scene(lookfrom = c(278, 278, -800) ,lookat = c(278, 278, 0), fov = 40, 
               ambient_light = FALSE, samples = 400, clamp_value = 5)
}

#Generate a gold sphere in the cornell box
\donttest{
generate_cornell() \%>\%
  add_object(sphere(x = 555/2, y = 100, z = 555/2, radius = 100, 
                    material = microfacet(color = "gold"))) \%>\%
  render_scene(lookfrom = c(278, 278, -800) ,lookat = c(278, 278, 0), fov = 40, 
               ambient_light = FALSE, samples = 400, clamp_value = 5)
}
}
