% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materials.R
\name{metal}
\alias{metal}
\title{Metallic Material}
\usage{
metal(
  color = "#ffffff",
  fuzz = 0,
  alpha_texture = NA,
  importance_sample = FALSE
)
}
\arguments{
\item{color}{Default `white`. The color of the sphere. Can be either
a hexadecimal code, R color string, or a numeric rgb vector listing three intensities between `0` and `1`.}

\item{fuzz}{Default `0`. The roughness of the metallic surface. Maximum `1`.}

\item{alpha_texture}{Default `NA`. A matrix or filename (specifying a greyscale image) to be used to specify the transparency.}

\item{importance_sample}{Default `FALSE`. If `TRUE`, the object will be sampled explicitly during 
the rendering process. If the object is particularly important in contributing to the light paths
in the image (e.g. light sources, refracting glass ball with caustics, metal objects concentrating light),
this will help with the convergence of the image.}
}
\value{
Single row of a tibble describing the metallic material.
}
\description{
Metallic Material
}
\examples{
#Generate the cornell box with a single metal sphere in the center
scene = generate_cornell() \%>\%
  add_object(sphere(x=555/2,y=555/2,z=555/2,radius=555/8,material=metal()))
\donttest{
render_scene(scene, lookfrom=c(278,278,-800),lookat = c(278,278,0), samples=500,
             aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}
#Add a rotated shiny metal cube     
scene = scene \%>\%
  add_object(cube(x=380,y=150/2,z=200,xwidth=150,ywidth=150,zwidth=150,
  material = metal(color="#8B4513"),angle=c(0,45,0)))
\donttest{
render_scene(scene, lookfrom=c(278,278,-800),lookat = c(278,278,0), samples=500,
             aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}
#Add a brushed metal cube (setting the fuzz variable)           
scene = scene \%>\%
  add_object(cube(x=150,y=150/2,z=300,xwidth=150,ywidth=150,zwidth=150,
  material = metal(color="#FAFAD2",fuzz=0.1),angle=c(0,-30,0)))
\donttest{
render_scene(scene, lookfrom=c(278,278,-800),lookat = c(278,278,0), samples=500,
             aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}
}
