% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{obj_mesh}
\alias{obj_mesh}
\title{OBJ Mesh 3D Model}
\usage{
obj_mesh(
  filename,
  center = FALSE,
  position = c(0, 0, 0),
  scale = c(1, 1, 1),
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  materialspath = NULL,
  material = NULL
)
}
\arguments{
\item{filename}{OBJ filename.}

\item{center}{Default `FALSE`. Whether to center the mesh.}

\item{position}{Default `c(0,0,0)`. Position of the mesh.}

\item{scale}{Default `c(1,1,1)`. Scale of the mesh. Can also be a single numeric value scaling all axes uniformly.}

\item{angle}{Default `c(0,0,0)`. Angle to rotate the mesh.}

\item{pivot_point}{Default `c(0,0,0)`. Point around which to rotate the mesh.}

\item{order_rotation}{Default `c(1,2,3)`. Order to rotate the axes.}

\item{materialspath}{Default `NULL`. Path to the MTL file, if different from the OBJ file.}

\item{material}{Default `NULL`, read from the MTL file. If not `NULL`, this accepts the output
from the `material_list()` function to specify the material.}
}
\value{
List describing the mesh.
}
\description{
OBJ Mesh 3D Model
}
\examples{
\dontshow{
options("cores"=1)
}
#Read in the provided 3D R mesh
\donttest{
generate_cornell_mesh(ceiling=FALSE) \%>\% 
  add_shape(obj_mesh(r_obj(),position=c(555/2,0,555/2),scale=150,angle=c(0,180,0))) \%>\% 
  rasterize_scene(light_info = directional_light(direction=c(0.2,0.5,-1)))
  }
}
