% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-yc.R
\name{yc_get}
\alias{yc_get}
\title{Fetches Yield Curve Data from B3}
\usage{
yc_get(
  first_date = Sys.Date() - 5,
  last_date = Sys.Date(),
  by = 1,
  cache_folder = cachedir(),
  do_cache = TRUE
)
}
\arguments{
\item{first_date}{First date ("YYYY-MM-DD")}

\item{last_date}{Last date ("YYYY-MM-DD")}

\item{by}{Number of days in between fetched dates (default = 1)}

\item{cache_folder}{Location of cache folder (default = cachedir())}

\item{do_cache}{Whether to use cache or not (default = TRUE)}
}
\value{
A dataframe/tibble with yield curve data
}
\description{
Downloads yield curve data from B3 website
\url{https://www2.bmf.com.br/pages/portal/bmfbovespa/lumis/lum-taxas-referenciais-bmf-ptBR.asp}.
Particularly, we import data for DI X Pre.
See \url{https://www.b3.com.br/data/files/8B/F5/11/68/5391F61043E561F6AC094EA8/Manual_de_Curvas.pdf}
for more details.
}
\examples{
\dontrun{
df_yc <- yc_get()
head(df_yc)
}
}
