% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-company.R
\name{company_stock_dividends_get}
\alias{company_stock_dividends_get}
\title{Gets company's stocks dividends}
\usage{
company_stock_dividends_get(code, cache_folder = cachedir(), do_cache = TRUE)
}
\arguments{
\item{code}{Represents the company, can be the stock symbol, like \code{PETR4} or
the first four characters \code{PETR}}

\item{cache_folder}{Location of cache folder (default = cachedir())}

\item{do_cache}{Whether to use cache or not (default = TRUE)}
}
\value{
data.frame with all stocks dividends
}
\description{
Gets a list of all stocks dividends paid by the company.
\emph{A stock dividend is a payment to shareholders that consists of additional
shares rather than cash.} (https://www.investopedia.com/)
}
\details{
The \code{code} parameter can be the stock symbol, but the returned data refers
to the company, always.
The returned data.frame has all company's symbols that paid dividends in
stocks.
}
\examples{
\dontrun{
company_stock_dividends_get(c("PETR", "VALE", "MGLU"))
}

}
