% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_subjectsearch.R
\name{bhl_subjectsearch}
\alias{bhl_subjectsearch}
\title{Return a list of subjects that match (fully or partially) the specified
search string.}
\usage{
bhl_subjectsearch(subject, as = "table", key = NULL, ...)
}
\arguments{
\item{subject}{the full or partial subject for which to search (character)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
Return a list of subjects that match (fully or partially) the specified
search string.
}
\examples{
\dontrun{
bhl_subjectsearch('diptera')
bhl_subjectsearch('diptera', "json")
}
}
