% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_publicationsearch.R
\name{bhl_publicationsearchadv}
\alias{bhl_publicationsearchadv}
\title{Publication search advanced}
\usage{
bhl_publicationsearchadv(
  title = NULL,
  titleop = NULL,
  authorname = NULL,
  year = NULL,
  subject = NULL,
  language = NULL,
  collection = NULL,
  notes = NULL,
  notesop = NULL,
  text = NULL,
  textop = NULL,
  page = NULL,
  as = "table",
  key = NULL,
  ...
)
}
\arguments{
\item{title}{(character) a title for which to search}

\item{titleop}{(character) 'all' to search for all specified words in the
title fields; 'phrase' to search for the exact phrase specified}

\item{authorname}{(character) an author name for which to search}

\item{year}{(integer) a four-digit publication year for which to search}

\item{subject}{(character) a subject for which to search}

\item{language}{(character) a language code; search will only return
publications in the specified language}

\item{collection}{(character) a collection id; search will only return
publications from the specfied collection}

\item{notes}{(character) one or more words for which to search in the
publication notes}

\item{notesop}{(character) 'all' to search for all specified words in the
notes field; 'phrase' to search for the exact phrase specified}

\item{text}{(character) one or more words for which to search in the text
of the publications}

\item{textop}{(character) 'all' to search for all specified words in the
text field; 'phrase' to search for the exact phrase specified}

\item{page}{(integer) 1 for the first page of results, 2 for the second,
and so on}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
Publication search advanced
}
\examples{
\dontrun{
bhl_publicationsearchadv(title = "cocos island", titleop = "all",
  authorname = "gifford", year = 1919)
bhl_publicationsearchadv(title = "cocos island", authorname = "gifford")
}
}
\seealso{
Other publication-search: 
\code{\link{bhl_publicationsearch}()}
}
\concept{publication-search}
