% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb.R
\name{rba_string_enrichment_ppi}
\alias{rba_string_enrichment_ppi}
\title{Get Protein-Protein Interaction Enrichment}
\usage{
rba_string_enrichment_ppi(ids, species = NA, required_score = NA, ...)
}
\arguments{
\item{ids}{Your protein ID(s). It is strongly recommended to provide
STRING IDs. See \code{\link{rba_string_map_ids}} for more information.}

\item{species}{Numeric: NCBI Taxonomy identifier; Human Taxonomy ID is 9606.
(Recommended, but optional if your input is less than 100 IDs.)}

\item{required_score}{Numeric: A minimum of interaction score for an
interaction to be included in the image. if not provided, the threshold
will be applied by STRING Based in the network. (low Confidence = 150,
Medium Confidence = 400, High Confidence = 700, Highest confidence = 900)}

\item{...}{rbioapi option(s). Refer to \code{\link{rba_options}}'s
arguments documentation for more information on available options.}
}
\value{
A list with protein-protein interaction enrichment results.
}
\description{
Even when there is no annotation for your input proteins, STRING can Compare
  your Given proteins interactions pattern with the background proteome-wide
  interaction distribution to determine if your given set of proteins are
  functionally related.
}
\section{Corresponding API Resources}{

 "POST https://string-db.org/api/[output_format]/ppi_enrichment?identifiers=
 [your_identifiers]&[optional_parameters]"
}

\examples{
\donttest{
rba_string_enrichment_ppi(ids = c("p53", "BRCA1", "cdk2", "Q99835",
       "CDC42", "CDK1", "KIF23", "PLK1", "RAC2", "RACGAP1"),
    species = 9606)
}

}
\references{
\itemize{
  \item Szklarczyk D, Gable AL, Lyon D, Junge A, Wyder S, Huerta-Cepas J,
  Simonovic M, Doncheva NT, Morris JH, Bork P, Jensen LJ, Mering CV.
  STRING v11: protein-protein association networks with increased coverage,
  supporting functional discovery in genome-wide experimental datasets.
  Nucleic Acids Res. 2019 Jan 8;47(D1):D607-D613. doi: 10.1093/nar/gky1131.
  PMID: 30476243; PMCID: PMC6323986.
  \item \href{https://string-db.org/help/api/}{STRING API Documentation}
  }
}
\seealso{
\code{\link{rba_string_map_ids}}

Other "STRING": 
\code{\link{rba_string_annotations}()},
\code{\link{rba_string_enrichment}()},
\code{\link{rba_string_homology_inter}()},
\code{\link{rba_string_homology_intra}()},
\code{\link{rba_string_interaction_partners}()},
\code{\link{rba_string_interactions_network}()},
\code{\link{rba_string_map_ids}()},
\code{\link{rba_string_network_image}()},
\code{\link{rba_string_version}()}
}
\concept{"STRING"}
