% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichr.R
\name{rba_enrichr_enrich}
\alias{rba_enrichr_enrich}
\title{Get Enrichr Enrichment Results}
\usage{
rba_enrichr_enrich(
  user_list_id,
  gene_set_library = "all",
  regex_library_name = TRUE,
  organism = "human",
  progress_bar = TRUE,
  ...
)
}
\arguments{
\item{user_list_id}{An ID returned to you after uploading a gene
list using \code{\link{rba_enrichr_add_list}}}

\item{gene_set_library}{One of the:
\enumerate{
\item "all" to select all of the available Enrichr gene-set libraries.
\item A gene-set library name existed in the results
retrieved via \code{\link{rba_enrichr_libs}}
\item If regex_library_name = TRUE, A partially-matching name a regex
pattern that correspond to one or more of Enrichr library names.
}}

\item{regex_library_name}{logical: if TRUE (default) the supplied
gene_set_library will be regarded as a regex or partially matching name. if
FALSE, gene_set_library will be considered exact match.}

\item{organism}{(default = "human") Which model organism version of Enrichr
to use? Available options are: "human", (H. sapiens & M. musculus),
"fly" (D. melanogaster), "yeast" (S. cerevisiae), "worm" (C. elegans)
and "fish" (D. rerio).}

\item{progress_bar}{logical: In case of selecting multiple Enrichr
libraries, should a progress bar be displayed?}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing data frames of the enrichment results of your
  supplied gene-list against the selected Enrichr libraries.
}
\description{
This function which will retrieve the enrichment results of your
  supplied gene-list id against one or multiple Enrichr libraries.
}
\details{
Note that using \code{\link{rba_enrichr}} is a more convenient way to
  automatically perform this and other required function calls to enrich
  your input gene-set.
}
\section{Corresponding API Resources}{

 "GET https://maayanlab.cloud/Enrichr/enrich"
}

\examples{
\dontrun{
rba_enrichr_enrich(user_list_id = "11111")
}
\dontrun{
rba_enrichr_enrich(user_list_id = "11111",
    gene_set_library = "GO_Molecular_Function_2017",
    regex_library_name = FALSE)
}
\dontrun{
rba_enrichr_enrich(user_list_id = "11111",
    gene_set_library = "go",
    regex_library_name = TRUE)
}

}
\references{
\itemize{
  \item Chen EY, Tan CM, Kou Y, Duan Q, Wang Z, Meirelles GV, Clark NR,
  Ma'ayan A. Enrichr: interactive and collaborative HTML5 gene list
  enrichment analysis tool. BMC Bioinformatics. 2013;128(14).
  \item Kuleshov MV, Jones MR, Rouillard AD, Fernandez NF, Duan Q, Wang Z,
  Koplev S, Jenkins SL, Jagodnik KM, Lachmann A, McDermott MG, Monteiro CD,
  Gundersen GW, Ma'ayan A. Enrichr: a comprehensive gene set enrichment
  analysis web server 2016 update. Nucleic Acids Research. 2016; gkw377.
  \item \href{https://maayanlab.cloud/Enrichr/help#api}{Enrichr API
  Documentation}
  }
}
\seealso{
\code{\link{rba_enrichr}}

Other "Enrichr": 
\code{\link{rba_enrichr_add_list}()},
\code{\link{rba_enrichr_gene_map}()},
\code{\link{rba_enrichr_libs}()},
\code{\link{rba_enrichr_view_list}()},
\code{\link{rba_enrichr}()}
}
\concept{"Enrichr"}
