% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichr.R
\name{rba_enrichr_view_list}
\alias{rba_enrichr_view_list}
\title{View an Uploaded Gene List}
\usage{
rba_enrichr_view_list(user_list_id, organism = "human", ...)
}
\arguments{
\item{user_list_id}{a user_list_id returned to you after uploading a gene
list using \code{\link{rba_enrichr_add_list}}}

\item{organism}{(default = "human") Which model organism version of Enrichr
to use? Available options are: "human", (H. sapiens & M. musculus),
"fly" (D. melanogaster), "yeast" (S. cerevisiae), "worm" (C. elegans)
and "fish" (D. rerio).}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing the genes and description available under the
  supplied user_list_id
}
\description{
Retrieve a list of uploaded genes under a 'user list ID'.
}
\section{Corresponding API Resources}{

 "GET https://maayanlab.cloud/Enrichr/view"
}

\examples{
\dontrun{
rba_enrichr_view_list(user_list_id = 11111)
}

}
\references{
\itemize{
  \item Chen EY, Tan CM, Kou Y, Duan Q, Wang Z, Meirelles GV, Clark NR,
  Ma'ayan A. Enrichr: interactive and collaborative HTML5 gene list
  enrichment analysis tool. BMC Bioinformatics. 2013;128(14).
  \item Kuleshov MV, Jones MR, Rouillard AD, Fernandez NF, Duan Q, Wang Z,
  Koplev S, Jenkins SL, Jagodnik KM, Lachmann A, McDermott MG, Monteiro CD,
  Gundersen GW, Ma'ayan A. Enrichr: a comprehensive gene set enrichment
  analysis web server 2016 update. Nucleic Acids Research. 2016; gkw377.
  \item \href{https://maayanlab.cloud/Enrichr/help#api}{Enrichr API
  Documentation}
  }
}
\seealso{
Other "Enrichr": 
\code{\link{rba_enrichr_add_list}()},
\code{\link{rba_enrichr_enrich}()},
\code{\link{rba_enrichr_gene_map}()},
\code{\link{rba_enrichr_libs}()},
\code{\link{rba_enrichr}()}
}
\concept{"Enrichr"}
