% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_matrix_versions}
\alias{rba_jaspar_matrix_versions}
\title{List matrix profile versions associated with a base ID}
\usage{
rba_jaspar_matrix_versions(base_id, order = NULL, ...)
}
\arguments{
\item{base_id}{Character: A base (stable) Identifier. A matrix profile
identifier has "base_id.version" naming schema}

\item{order}{Character: A character string or a vector of character strings
of field names that will be used to order the results.
\cr Providing multiple field names is supported. You can also use prefix
"-" before a field name to indicate reverse ordering.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame of matrix profiles' versions information.
}
\description{
Since JASPAR release 2010, the matrix profiles
  are versioned; So, a matrix profile Identifier has "base_id.version"
  naming schema. Using this function you can retrieve a list of matrix
  profiles associated with a base (stable) ID.
}
\section{Corresponding API Resources}{

 "GET "http://jaspar.genereg.net/api/v1/matrix/{base_id}/versions/"
}

\examples{
\donttest{
rba_jaspar_matrix_versions("MA0600")
}

}
\references{
\itemize{
  \item Fornes O, Castro-Mondragon JA, Khan A, et al. JASPAR 2020: update
    of the open-access database of transcription factor binding profiles.
    Nucleic Acids Res. 2019; doi: 10.1093/nar/gkz1001
  \item Khan, A. and Mathelier, A. JASPAR RESTful API: accessing JASPAR
    data from any programming language. Bioinformatics, 2017, doi:
    10.1093/bioinformatics/btx804
  \item Khan, A. et al. JASPAR 2018: update of the open-access database
    of transcription factor binding profiles and its web framework.
    Nucleic Acids Res. 2018; 46:D260–D266, doi: 10.1093/nar/gkx1126
  \item
  \href{http://jaspar.genereg.net/api/v1/docs/}{JASPAR API Documentation}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_collections}()},
\code{\link{rba_jaspar_matrix_search}()},
\code{\link{rba_jaspar_matrix}()},
\code{\link{rba_jaspar_releases}()},
\code{\link{rba_jaspar_sites}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_taxons_matrices}()},
\code{\link{rba_jaspar_taxons}()},
\code{\link{rba_jaspar_tffm_search}()},
\code{\link{rba_jaspar_tffm}()}
}
\concept{"JASPAR"}
