% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mieaa.R
\name{rba_mieaa_convert_version}
\alias{rba_mieaa_convert_version}
\title{Convert miRNA accession Between Different miRBase Versions}
\usage{
rba_mieaa_convert_version(
  mirna,
  mirna_type,
  input_version,
  output_version,
  simple_output = FALSE,
  ...
)
}
\arguments{
\item{mirna}{A vector of miRNA accessions to be converted.}

\item{mirna_type}{Type of your supplied miRNA accession. either "mature"
or "precursor".}

\item{input_version}{(numeric) miRBase version of your supplied miRNA
accessions.}

\item{output_version}{(numeric) To what version should your miRNA accessions
be converted?}

\item{simple_output}{(logical) If FALSE (default), the result will be a
two-columned data frame with your input and output accessions. Otherwise,
if TRUE, only the output miRNA accessions will be returned.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
Depending on the arguments, a data frame or a character vectors
  containing the miRNA accessions in your output version.
}
\description{
miEAA works with miRBASE v22 accession. Using This function you can convert
  a set of mature or precursor miRNA accession between two given miRBase
  versions.
}
\section{Corresponding API Resources}{

 "POST https://ccb-compute2.cs.uni-saarland.de/mieaa2/api/v1/mirbase_converter/"
}

\examples{
\donttest{
Sys.sleep(1) # to prevent 429 error during R CMD check
rba_mieaa_convert_version(mirna = c("hsa-miR-20b-5p", "hsa-miR-144-5p"),
    mirna_type = "mature", input_version = 22, output_version =  16)
}

}
\references{
\itemize{
  \item Fabian Kern, Tobias Fehlmann, Jeffrey Solomon, Louisa Schwed,
  Nadja Grammes, Christina Backes, Kendall Van Keuren-Jensen,
  David Wesley Craig,Eckart Meese, Andreas Keller, miEAA 2.0:
  integrating multi-species microRNA enrichment analysis and workflow
  management systems, Nucleic Acids Research, Volume 48, Issue W1,
  02 July 2020, Pages W521–W528, https://doi.org/10.1093/nar/gkaa309
  \item
  \href{https://ccb-compute2.cs.uni-saarland.de/mieaa2/tutorial/api/}{miEAA
  browsable API tutorial}
  \item \href{https://ccb-compute2.cs.uni-saarland.de/mieaa2/}{Citations note
  on miEAA website}
  }
}
\seealso{
Other "miEAA": 
\code{\link{rba_mieaa_cats}()},
\code{\link{rba_mieaa_convert_type}()},
\code{\link{rba_mieaa_enrich_results}()},
\code{\link{rba_mieaa_enrich_status}()},
\code{\link{rba_mieaa_enrich_submit}()},
\code{\link{rba_mieaa_enrich}()}
}
\concept{"miEAA"}
