% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_rna_edit_search}
\alias{rba_uniprot_rna_edit_search}
\title{Search RNA Editing in UniProt}
\usage{
rba_uniprot_rna_edit_search(
  accession = NULL,
  taxid = NULL,
  variantlocation = NULL,
  ...
)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}(s). You can supply up to 100
accession numbers.}

\item{taxid}{(Numeric) NIH-NCBI \href{https://www.uniprot.org/taxonomy/}{Taxon ID}.
You can supply up to 20 taxon IDs.}

\item{variantlocation}{Character: RNA editing variant location(s).
You can supply up to 20 taxon IDs.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A List where each element corresponds to one UniProt entity returned
  by your search query. The element itself is a sub-list containing all
  information that UniProt has about that entity.
}
\description{
UniProt Curates \href{https://www.uniprot.org/help/rna_editing}{RNA-editing
  events} (conversion, insertion, deletion of nucleotides). Use this
  function to search RNA editing records in UniProt using various
  criteria such as accession, taxon ID, or variant location.
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/rna-editing"
}

\examples{
\donttest{
  rba_uniprot_rna_edit_search(accession = c("Q16851", "Q16849"))
}

}
\concept{"UniProt - RNA Editing"}
