% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.div.r
\name{alpha.div}
\alias{alpha.div}
\title{Estimate the diversity of each sample.}
\usage{
alpha.div(biom, rarefy = FALSE)
}
\arguments{
\item{biom}{A \code{matrix}, \code{simple_triplet_matrix}, or \code{BIOM}
object, as returned from \link{read.biom}. For matrices, the rows and
columns are assumed to be the taxa and samples, respectively.}

\item{rarefy}{Control how/whether rarefactions are done prior to alpha 
diversity computations. Options are: 
\describe{
  \item{\code{FALSE}}{ Use each sample's current set of observations without
                  applying any rarefaction. (Default) }
  \item{\code{TRUE}}{ Automatically select and apply a single rarefaction. }
  \item{\code{"multi"}}{ Automatically select and apply multiple rarefactions. }
  \item{\emph{integer vector}}{ Rarefy at the specified depth(s). }
}}
}
\value{
A data frame of four diversity values for each sample in
    \code{biom}. The column names are \bold{Sample}, \bold{Depth} and the 
    diversity metrics: \bold{OTUs}, \bold{Shannon}, \bold{Chao1}, \bold{Simpson}, 
    and \bold{InvSimpson}. The row names are the sample names, except when
    multiple rarefactions are done.
}
\description{
Estimate the diversity of each sample.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "hmp50.biom", package = "rbiom")
    biom <- read.biom(infile)
    
    ad <- alpha.div(biom)
    head(ad)
    
    biom <- subset(biom, `Body Site` == "Saliva" & Age < 26)
    ad   <- alpha.div(biom, "multi")
    boxplot(Shannon ~ Depth, data=ad, xlab="Reads", ylab="Diversity")
    
}
