% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.rbridge}
\alias{predict.rbridge}
\title{Make predictions from a 'rbridge' object}
\usage{
\method{predict}{rbridge}(object, newx, s = c("lambda.min",
  "lambda.1se"), type = c("response", "nonzero", "coefficients"), ...)
}
\arguments{
\item{object}{A 'rbridge' object.}

\item{newx}{Matrix of new values for x at which predictions are to be made.}

\item{s}{Value(s) of the penalty parameter lambda at which predictions are required.}

\item{type}{It should one of "response", "nonzero" or "coefficients". The "response" is for predicted values, the "nonzero" is for exacting non-zero coefficients and the "coefficients" is for the estimated coefficients.}

\item{...}{Additional arguments for compatibility.}
}
\value{
Among a matrix with predictions, a vector non-zero indexing or a vector of coefficients
}
\description{
Makes predictions from a cross-validated 'rbridge' model
}
\examples{
set.seed(2019) 
beta <- c(3, 1.5, 0, 0, 2, 0, 0, 0)
p <- length(beta)
beta <- matrix(beta, nrow = p, ncol = 1)

### Restricted Matrix and vector
c1 <- c(1,1,0,0,1,0,0,0)
R1.mat <- matrix(c1,nrow = 1, ncol = p)
r1.vec <- as.matrix(c(6.5),1,1)

n = 100
X = matrix(rnorm(n*p),n,p)
y = X\%*\%beta + rnorm(n) 

######## Model 1 based on first restrictions
model1 <- rbridge(X, y, q = 1, R1.mat, r1.vec)
predict(model1,newx=X[1:5,], s="lambda.min", type="response")
predict(model1, s="lambda.min",type="coefficient")
}
\seealso{
\code{\link{coef.cv.bridge}}
}
\author{
Bahadir Yuzbasi, Mohammad Arashi and Fikri Akdeniz \cr Maintainer: Bahadir Yuzbasi \email{b.yzb@hotmail.com}
}
