% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc.R
\name{standardise}
\alias{standardise}
\title{Standardise data}
\usage{
standardise(x, scale = TRUE)
}
\arguments{
\item{x}{A numeric matrix (or vector).}

\item{scale}{A logical; if \code{TRUE} each column of \code{x} is divided by the square root of the sum of its centred squares.}
}
\value{
Matrix with centred (and optionally scaled) columns.
}
\description{
Standardises the columns of a numeric matrix \code{x} (similar to R-function \code{scale}).
If \code{x} is a vector, it is treated as a 1-column matrix.
}
\details{
This function is much faster than \code{scale}.
}
\examples{
x <- matrix(rnorm(100*10), nrow = 100, ncol = 10)
x <- standardise(x)
standard.deviations <- apply(x,2,sd)
print(standard.deviations)
}

