% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_lens_coef.R
\name{test_lens_coef}
\alias{test_lens_coef}
\title{Test lens projection functions}
\usage{
test_lens_coef(lens_coef)
}
\arguments{
\item{lens_coef}{Numeric vector. Polynomial coefficients of the lens
projection function.}
}
\value{
Returns \code{invisible(TRUE)} if all tests pass, otherwise throws an
  error.
}
\description{
Test that lens projection function works between the 0-to-1 range.
}
\examples{
test_lens_coef(lens("Nikon_FCE9"))
test_lens_coef(2 / pi)
}
\seealso{
Other Lens functions: 
\code{\link{azimuth_image}()},
\code{\link{calc_diameter}()},
\code{\link{calc_zenith_raster_coordinates}()},
\code{\link{calibrate_lens}()},
\code{\link{expand_noncircular}()},
\code{\link{lens}()},
\code{\link{reproject_to_equidistant}()},
\code{\link{zenith_image}()}
}
\concept{Lens functions}
