% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheye_to_equidistant.R
\name{fisheye_to_equidistant}
\alias{fisheye_to_equidistant}
\alias{reproject_to_equidistant}
\title{Fisheye to equidistant}
\usage{
fisheye_to_equidistant(r, z, a, radius = 745)

reproject_to_equidistant(r, z, a, radius = 745)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link{zenith_image}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link{azimuth_image}}.}

\item{radius}{Numeric integer of length one. Radius of the reprojected
hemispherical image (i.e., the output).}
}
\description{
Fisheye to equidistant projection (also known as polar projection).
}
\details{
There is no interpolation, so \code{NA} values may be generated depending on
both the \code{radius} argument and how much the lens projection differs from
the polar one. As a rule of thumb, increase \code{radius} as long as it does
not produce \code{NA} values on the regions to be analyzed.
}
\examples{
\dontrun{
caim <- read_caim()
caim <- normalize(caim, 0, 255)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
bin <- apply_thr(caim$Blue, 0.5)
bin_equi <- fisheye_to_equidistant(bin, z, a, radius = 400)
bin_equi <- apply_thr(bin_equi, 0.5)
plot(bin)
plot(bin_equi)
# use write_bin(bin, "path/file_name") to have a file ready
# for calculating LAI with CIMES, GLA, CAN-EYE, etc.
}
}
\seealso{
Other Lens Functions: 
\code{\link{azimuth_image}()},
\code{\link{calc_diameter}()},
\code{\link{calc_zenith_raster_coord}()},
\code{\link{calibrate_lens}()},
\code{\link{expand_noncircular}()},
\code{\link{fisheye_to_pano}()},
\code{\link{lens}()},
\code{\link{test_lens_coef}()},
\code{\link{zenith_image}()}
}
\concept{Lens Functions}
