% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_coneshaped_model.R
\name{fit_coneshaped_model}
\alias{fit_coneshaped_model}
\title{Fit cone-shaped model}
\usage{
fit_coneshaped_model(sky_points, use_azimuth_angle = TRUE)
}
\arguments{
\item{sky_points}{The \emph{data.frame} returned by \code{\link{extract_rl}}
or a \emph{data.frame} with same structure and names.}

\item{use_azimuth_angle}{Logical vector of length one. If \code{TRUE}, the
Equation 4 from \insertCite{Diaz2018;textual}{rcaiman}) is used: \eqn{sDN =
a + b \cdot \theta + c  \cdot \theta^2 + d  \cdot sin(\phi) + e  \cdot
cos(\phi)}, where \eqn{sDN} is sky digital number, \eqn{a,b,c,d} and
\eqn{e} are coefficients, \eqn{\theta} is zenith angle, and \eqn{\phi} is
azimuth angle. If \code{FALSE}, the next simplified version based on
\insertCite{Wagner2001;textual}{rcaiman} is used: \eqn{sDN = a + b \cdot
\theta + c  \cdot \theta^2}.}
}
\value{
A list of two objects, one of class \code{function} and the other of
  class \code{lm} (see \code{\link[stats]{lm}}). If the fitting fails, it
  returns \code{NULL}. The function requires two arguments--zenith and
  azimuth in degrees--to return relative luminance.
}
\description{
Statistical modeling to predict the digital numbers from spherical
coordinates.
}
\details{
An explanation of this model can be found on
\insertCite{Diaz2018;textual}{rcaiman}, under the heading \emph{Estimation of
the sky DN as a previous step for our method}.

If you use this function in your research, please cite
\insertCite{Diaz2018;textual}{rcaiman} in addition to this package.
}
\examples{
\dontrun{
path <- system.file("external/DSCN4500.JPG", package = "rcaiman")
caim <- read_caim(path, c(1280, 960) - 745, 745 * 2, 745 * 2)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
r <- gbc(caim$Blue)
g <- sky_grid_segmentation(z, a, 10)
bin <- find_sky_pixels(r, z, a)
sky_points <- extract_sky_points(r, bin, g)
sky_points <- extract_rl(r, z, a, sky_points, NULL)
model <- fit_coneshaped_model(sky_points$sky_points)
sky_cs <- model$fun(z, a)
persp(sky_cs, theta = 90, phi = 0) #a flipped rounded cone!
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{thr_image}}

Other Sky Reconstruction Functions: 
\code{\link{cie_sky_model_raster}()},
\code{\link{fit_cie_sky_model}()},
\code{\link{fit_trend_surface}()},
\code{\link{fix_reconstructed_sky}()},
\code{\link{interpolate_sky_points}()},
\code{\link{ootb_sky_reconstruction}()}
}
\concept{Sky Reconstruction Functions}
