/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Leaf;
import org.jmol.bspt.Node;
import org.jmol.bspt.Tuple;

public class SphereIterator {
    Bspt bspt;
    Element[] stack;
    int sp;
    int leafIndex;
    Leaf leaf;
    Tuple center;
    float radius;
    float[] centerValues;
    float radius2;
    float foundDistance2;
    boolean tHemisphere;

    SphereIterator(Bspt bspt) {
        this.bspt = bspt;
        this.centerValues = new float[bspt.dimMax];
        this.stack = new Element[bspt.treeDepth];
    }

    public void initialize(Tuple center, float radius) {
        this.center = center;
        this.radius = radius;
        this.radius2 = radius * radius;
        this.tHemisphere = false;
        int dim = this.bspt.dimMax;
        while (--dim >= 0) {
            this.centerValues[dim] = center.getDimensionValue(dim);
        }
        this.leaf = null;
        this.stack[0] = this.bspt.eleRoot;
        this.sp = 1;
        this.findLeftLeaf();
    }

    public void initializeHemisphere(Tuple center, float radius) {
        this.initialize(center, radius);
        this.tHemisphere = true;
    }

    public void release() {
        int i = this.bspt.treeDepth;
        while (--i >= 0) {
            this.stack[i] = null;
        }
    }

    public boolean hasMoreElements() {
        while (this.leaf != null) {
            while (this.leafIndex < this.leaf.count) {
                if (this.isWithinRadius(this.leaf.tuples[this.leafIndex])) {
                    return true;
                }
                ++this.leafIndex;
            }
            this.findLeftLeaf();
        }
        return false;
    }

    public Tuple nextElement() {
        return this.leaf.tuples[this.leafIndex++];
    }

    public float foundDistance2() {
        return this.foundDistance2;
    }

    private void findLeftLeaf() {
        this.leaf = null;
        if (this.sp == 0) {
            return;
        }
        Element ele = this.stack[--this.sp];
        while (ele instanceof Node) {
            Node node = (Node)ele;
            float centerValue = this.centerValues[node.dim];
            float maxValue = centerValue + this.radius;
            float minValue = centerValue;
            if (!this.tHemisphere || node.dim != 0) {
                minValue -= this.radius;
            }
            if (minValue <= node.maxLeft && maxValue >= node.minLeft) {
                if (maxValue >= node.minRight && minValue <= node.maxRight) {
                    this.stack[this.sp++] = node.eleRight;
                }
                ele = node.eleLeft;
                continue;
            }
            if (maxValue >= node.minRight && minValue <= node.maxRight) {
                ele = node.eleRight;
                continue;
            }
            if (this.sp == 0) {
                return;
            }
            ele = this.stack[--this.sp];
        }
        this.leaf = (Leaf)ele;
        this.leafIndex = 0;
    }

    private boolean isWithinRadius(Tuple t) {
        float distT = t.getDimensionValue(0) - this.centerValues[0];
        if (this.tHemisphere && distT < 0.0f) {
            return false;
        }
        float dist2 = distT * distT;
        if (dist2 > this.radius2) {
            return false;
        }
        int dim = this.bspt.dimMax - 1;
        do {
            if (!((dist2 += (distT = t.getDimensionValue(dim) - this.centerValues[dim]) * distT) > this.radius2)) continue;
            return false;
        } while (--dim > 0);
        this.foundDistance2 = dist2;
        return true;
    }
}

