/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jcamp;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Container;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jmol.jcamp.GraphCharacteristics;
import org.jmol.jcamp.SaisieDlg;
import org.jmol.jcamp.ZoneVisu;
import org.jmol.jcamp.utils.NumericDataUtils;
import org.jmol.jcamp.utils.StringDataUtils;

public class Visua
extends Applet
implements Runnable {
    ZoneVisu My_ZoneVisu;
    Thread My_Thread;
    private GraphCharacteristics _graphDataUtils;
    public Vector texte;
    public int nbLignes;
    int shitty_starting_constant = 66666;
    public double Firstx;
    public double Lastx;
    public double YFactor;
    public int Nbpoints;
    public double nmr_observe_frequency;
    public String TexteTitre;
    public String x_units;
    public String y_units;
    public String Datatype;
    Button Load_File;
    Button Zoom_In;
    Button Zoom_Back;
    Button Zoom_Out;
    Checkbox Reverse;
    Checkbox Grid;
    Checkbox Integrate;
    Button Find_Peak;
    Button JCamp;
    Frame Fenetre_Load_File;
    SaisieDlg Dialogue_Load_File;
    AppletContext contexte;
    String clickable_peaks_frame_name;
    boolean Flag_Zoomin = false;
    boolean Flag_Zoomback = false;
    boolean Flag_Zoomout = false;
    boolean Flag_Reverse = false;
    boolean Flag_Integrate = false;
    boolean Flag_Dialogue_File_Enabled = false;
    boolean Flag_Redraw = false;
    boolean Flag_Find_Peak = false;
    boolean Flag_Write_JCamp = false;
    boolean isActive = false;
    boolean hasPrivilege = false;
    boolean inNavigator = false;
    boolean inExplorer = false;
    FileDialog openDialog;
    FileDialog saveDialog;
    String Current_Error = "";

    public void init() {
        this.showStatus("Initializing jcamp/spc visualizer, please wait...");
        System.out.println("jcamp/spc visualizer v2.0.0 (c) G. Cottenceau 1998");
        if (this.inNavigator) {
            Container c;
            for (c = this.getParent(); c != null && !(c instanceof Frame); c = c.getParent()) {
            }
            this.saveDialog = new FileDialog((Frame)c, "Save JCAMP", 1);
        }
        this.setLayout(new BorderLayout());
        Panel Mes_Boutons = new Panel();
        Mes_Boutons.setLayout(new GridLayout(1, 1));
        if (this.getParameter("INTEGRATE") != null && this.getParameter("INTEGRATE").compareTo("TRUE") == 0) {
            this.Integrate = new Checkbox("Integrate");
            Mes_Boutons.add(this.Integrate);
        }
        if (this.getParameter("LOAD_FILE") != null && this.getParameter("LOAD_FILE").compareTo("SHOW") == 0) {
            Mes_Boutons.add(this.Load_File);
        }
        this.add("South", Mes_Boutons);
        this.My_ZoneVisu = new ZoneVisu();
        this.initGraphParameters();
        this.add("Center", this.My_ZoneVisu);
        this.layout();
        this.contexte = this.getAppletContext();
        this.clickable_peaks_frame_name = this.getParameter("CLICKABLE_PEAKS_FRAME_NAME");
        this.My_ZoneVisu.Y_Values = this.getParameter("Y_VALUES");
        this.My_ZoneVisu.ShowTitle = this.getParameter("TITLE");
        this.My_ZoneVisu.Flag_Clickable_Peaks = this.Load_Clickable_Peaks_Source_File(this.getParameter("CLICKABLE_PEAKS_SOURCE_FILE"));
        this.My_ZoneVisu.init();
        this.My_ZoneVisu.setGraphDataUtils(this._graphDataUtils);
        this.Really_Load_File(this.getParameter("SOURCE_FILE"));
        if (this.getParameter("CLICKABLE_PEAKS_FIRST_FRAME") != null) {
            this.My_ZoneVisu.Flag_Load_Now_Html = true;
            this.My_ZoneVisu.Name_Load_Now_Html = this.getParameter("CLICKABLE_PEAKS_FIRST_FRAME");
        }
    }

    private void initGraphParameters() {
        this._graphDataUtils = new GraphCharacteristics();
        if (this.getParameter("GRID") != null && this.getParameter("GRID").compareTo("TRUE") == 0) {
            this._graphDataUtils.setGrid(true);
            this.My_ZoneVisu.Flag_Grid = true;
        } else {
            this._graphDataUtils.setGrid(false);
        }
        if (this.getParameter("INTEGRATION_VALUES") != null) {
            this._graphDataUtils.setUnsortedIntegrationValues(this.getParameter("INTEGRATION_VALUES"));
        }
        if (this.getParameter("REVERSE") != null && this.getParameter("REVERSE").compareTo("TRUE") == 0) {
            this._graphDataUtils.setReverse(true);
            this.Flag_Reverse = true;
            this.My_ZoneVisu.reverse = true;
        }
        if (this.getParameter("AXIS_COLOR") != null) {
            this._graphDataUtils.setAxisColor(this.getParameter("AXIS_COLOR"));
        }
        if (this.getParameter("AXIS_TEXT_COLOR") != null) {
            this._graphDataUtils.setAxisTextColor(this.getParameter("AXIS_TEXT_COLOR"));
        }
        if (this.getParameter("INTEGRATE_CURVE_COLOR") != null) {
            this._graphDataUtils.setIntegrateCurveColor(this.getParameter("INTEGRATE_CURVE_COLOR"));
        }
        if (this.getParameter("INTEGRATE_TEXT_COLOR") != null) {
            this._graphDataUtils.setIntegrateTextColor(this.getParameter("INTEGRATE_TEXT_COLOR"));
        }
        if (this.getParameter("GRAPH_CURVE_COLOR") != null) {
            this._graphDataUtils.setGraphCurveColor(this.getParameter("GRAPH_CURVE_COLOR"));
        }
        if (this.getParameter("TEXT_COLOR") != null) {
            this._graphDataUtils.setTextColor(this.getParameter("TEXT_COLOR"));
        }
    }

    public void start() {
        if (this.My_Thread == null) {
            this.My_Thread = new Thread(this);
            this.My_Thread.start();
        }
        this.showStatus("Ready");
    }

    public void stop() {
        if (this.My_Thread != null) {
            this.My_Thread.stop();
            this.My_Thread = null;
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.Flag_Zoomin) {
                System.out.println("Zooming in!");
                this.My_ZoneVisu.Zoomin();
                this.Flag_Zoomin = false;
            }
            if (this.Flag_Zoomback) {
                this.My_ZoneVisu.Zoomback();
                this.Flag_Zoomback = false;
            }
            if (this.Flag_Zoomout) {
                this.My_ZoneVisu.Zoomout();
                this.Flag_Zoomout = false;
            }
            if (this.Flag_Reverse) {
                this.My_ZoneVisu.Reverse();
                this.Flag_Reverse = false;
            }
            if (this.Flag_Integrate) {
                this.My_ZoneVisu.Flag_Integrate = true;
                this.My_ZoneVisu.Redraw();
                this.Flag_Integrate = false;
            }
            if (this.Flag_Find_Peak) {
                this.My_ZoneVisu.Find_Peak();
                this.Flag_Find_Peak = false;
            }
            if (this.Flag_Write_JCamp && this.getParameter("SOURCE_FILE").toLowerCase().endsWith("dx")) {
                this.Write_JCamp();
                this.Flag_Write_JCamp = false;
            }
            if (this.Flag_Redraw) {
                this.My_ZoneVisu.Redraw();
                this.Flag_Redraw = false;
            }
            if (this.My_ZoneVisu.Flag_Load_Now_Html) {
                this.My_ZoneVisu.Flag_Load_Now_Html = false;
                try {
                    this.contexte.showDocument(new URL(this.getDocumentBase(), this.My_ZoneVisu.Name_Load_Now_Html), this.clickable_peaks_frame_name);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (!this.Flag_Dialogue_File_Enabled || !this.Dialogue_Load_File.fin) continue;
            this.Flag_Dialogue_File_Enabled = false;
            this.Dialogue_Load_File.fin = false;
            if (!this.Dialogue_Load_File.OkStatus) continue;
            this.Really_Load_File(this.Dialogue_Load_File.lisSaisie());
        }
    }

    public boolean Load_Clickable_Peaks_Source_File(String tam) {
        if (tam == null) {
            return false;
        }
        try {
            String s;
            URL url = new URL(this.getDocumentBase(), tam);
            InputStream stream = url.openStream();
            DataInputStream fichier = new DataInputStream(stream);
            this.texte = new Vector();
            while ((s = fichier.readLine()) != null) {
                this.texte.addElement(s);
            }
            this.My_ZoneVisu.Nb_Clickable_Peaks = this.texte.size();
        }
        catch (Exception e) {
            return false;
        }
        this.My_ZoneVisu.Peak_Start = new double[this.My_ZoneVisu.Nb_Clickable_Peaks];
        this.My_ZoneVisu.Peak_Stop = new double[this.My_ZoneVisu.Nb_Clickable_Peaks];
        this.My_ZoneVisu.Peak_Html = new String[this.My_ZoneVisu.Nb_Clickable_Peaks];
        int cpt_tokens = 0;
        int i = 0;
        while (cpt_tokens < this.My_ZoneVisu.Nb_Clickable_Peaks) {
            StringTokenizer mon_token;
            do {
                String mysub = (String)this.texte.elementAt(cpt_tokens);
                mon_token = new StringTokenizer(mysub, " ");
            } while (++cpt_tokens < this.My_ZoneVisu.Nb_Clickable_Peaks && !mon_token.hasMoreTokens());
            if (mon_token.hasMoreTokens()) {
                this.My_ZoneVisu.Peak_Start[i] = Double.valueOf(mon_token.nextToken());
                this.My_ZoneVisu.Peak_Stop[i] = Double.valueOf(mon_token.nextToken());
                if (this.My_ZoneVisu.Peak_Start[i] > this.My_ZoneVisu.Peak_Stop[i]) {
                    double temp = this.My_ZoneVisu.Peak_Start[i];
                    this.My_ZoneVisu.Peak_Start[i] = this.My_ZoneVisu.Peak_Stop[i];
                    this.My_ZoneVisu.Peak_Stop[i] = temp;
                }
                this.My_ZoneVisu.Peak_Html[i] = mon_token.nextToken();
            }
            ++i;
        }
        return true;
    }

    public String Move_Points_To_Tableau() {
        String Un_Nombre;
        String mysub;
        double[] tmp_tab;
        int indicetableau;
        int indice = 0;
        int nbp = this.Nbpoints;
        if (this.Datatype.compareTo("XYDATA") == 0) {
            while (StringDataUtils.jcampSubString((String)this.texte.elementAt(indice), 0, 8).compareTo("##XYDATA") != 0) {
                ++indice;
            }
            ++indice;
            indicetableau = 0;
            this.My_ZoneVisu.tableau_points = new double[this.Nbpoints];
            tmp_tab = new double[this.Nbpoints];
            while (nbp > 0 && indice < this.nbLignes) {
                StringTokenizer mon_token;
                do {
                    mysub = (String)this.texte.elementAt(indice);
                    mon_token = new StringTokenizer(mysub, " ");
                } while (++indice < this.nbLignes && !mon_token.hasMoreTokens());
                if (!mon_token.hasMoreTokens()) continue;
                Un_Nombre = mon_token.nextToken();
                while (nbp > 0 && (mon_token.hasMoreTokens() || Un_Nombre.indexOf(45) > 1)) {
                    Un_Nombre = Un_Nombre.indexOf(45) <= 1 ? mon_token.nextToken() : Un_Nombre.substring(Un_Nombre.indexOf(45) + 1);
                    while (Un_Nombre.indexOf(45) > 1) {
                        --nbp;
                        try {
                            this.My_ZoneVisu.tableau_points[indicetableau] = Double.valueOf(Un_Nombre.substring(0, Un_Nombre.indexOf(45)));
                        }
                        catch (Exception e) {
                            return ", wrong number format";
                        }
                        ++indicetableau;
                        Un_Nombre = Un_Nombre.substring(Un_Nombre.indexOf(45) + 1);
                    }
                    --nbp;
                    try {
                        this.My_ZoneVisu.tableau_points[indicetableau] = Double.valueOf(Un_Nombre);
                    }
                    catch (Exception e) {
                        return ", wrong number format";
                    }
                    ++indicetableau;
                }
            }
            if (this.Firstx > this.Lastx) {
                int i;
                for (i = 0; i < this.Nbpoints; ++i) {
                    tmp_tab[i] = this.My_ZoneVisu.tableau_points[i];
                }
                for (i = 0; i < this.Nbpoints; ++i) {
                    this.My_ZoneVisu.tableau_points[i] = tmp_tab[this.Nbpoints - i - 1];
                }
                double tmp = this.Firstx;
                this.Firstx = this.Lastx;
                this.Lastx = tmp;
            }
        }
        if (this.Datatype.compareTo("PEAK TABLE") == 0) {
            while (((String)this.texte.elementAt(indice)).substring(0, 6).compareTo("##PEAK") != 0) {
                ++indice;
            }
            ++indice;
            indicetableau = 0;
            this.My_ZoneVisu.tableau_points = new double[this.Nbpoints * 2];
            tmp_tab = new double[this.Nbpoints * 2];
            while (nbp > 0 && indice < this.nbLignes) {
                StringTokenizer mon_token;
                do {
                    mysub = (String)this.texte.elementAt(indice);
                    mon_token = new StringTokenizer(mysub, " ");
                } while (++indice < this.nbLignes && !mon_token.hasMoreTokens());
                if (!mon_token.hasMoreTokens()) continue;
                while (nbp > 0 && mon_token.hasMoreTokens()) {
                    Un_Nombre = mon_token.nextToken();
                    --nbp;
                    this.My_ZoneVisu.tableau_points[indicetableau] = Double.valueOf(Un_Nombre.substring(0, Un_Nombre.indexOf(44)));
                    this.My_ZoneVisu.tableau_points[++indicetableau] = Un_Nombre.indexOf(44) == Un_Nombre.length() - 1 ? Double.valueOf(mon_token.nextToken()).doubleValue() : Double.valueOf(Un_Nombre.substring(Un_Nombre.indexOf(44) + 1)).doubleValue();
                    ++indicetableau;
                }
            }
            if (this.Firstx == (double)this.shitty_starting_constant) {
                this.Firstx = this.My_ZoneVisu.tableau_points[0];
            }
            if (this.Lastx == (double)this.shitty_starting_constant) {
                this.Lastx = this.My_ZoneVisu.tableau_points[(this.Nbpoints - 1) * 2];
            }
            if (this.Firstx > this.Lastx) {
                int i;
                for (i = 0; i < this.Nbpoints; ++i) {
                    tmp_tab[i * 2] = this.My_ZoneVisu.tableau_points[i * 2];
                }
                for (i = 0; i < this.Nbpoints; ++i) {
                    this.My_ZoneVisu.tableau_points[i * 2] = tmp_tab[this.Nbpoints * 2 - i * 2 - 1];
                }
                for (i = 0; i < this.Nbpoints; ++i) {
                    tmp_tab[i * 2 + 1] = this.My_ZoneVisu.tableau_points[i * 2 + 1];
                }
                for (i = 0; i < this.Nbpoints; ++i) {
                    this.My_ZoneVisu.tableau_points[i * 2 + 1] = tmp_tab[this.Nbpoints * 2 - i * 2];
                }
                double tmp = this.Firstx;
                this.Firstx = this.Lastx;
                this.Lastx = tmp;
            }
        }
        if (nbp > 0) {
            return ", file corrupted or unsupported file format";
        }
        return "OK";
    }

    public boolean initFile(String filename) {
        String resultat_move_points;
        this.showStatus("Loading the file, please wait...");
        this.x_units = "?";
        this.y_units = "ARBITRARY";
        this.Datatype = "UNKNOWN";
        if (filename.toLowerCase().endsWith(".spc")) {
            try {
                int i;
                URL url = new URL(this.getDocumentBase(), filename);
                InputStream stream = url.openStream();
                DataInputStream fichier = new DataInputStream(stream);
                byte ftflgs = fichier.readByte();
                byte fversn = fichier.readByte();
                if (ftflgs != 0 && ftflgs != 32 || fversn != 75) {
                    this.Current_Error = ", support only Evenly Spaced new version 4B";
                    return false;
                }
                byte fexp = fichier.readByte();
                if (fexp != 128) {
                    this.YFactor = Math.pow(2.0, fexp) / Math.pow(2.0, 32.0);
                }
                this.Nbpoints = NumericDataUtils.convToIntelInt(fichier.readInt());
                if (this.Firstx == (double)this.shitty_starting_constant) {
                    this.Firstx = NumericDataUtils.convToIntelDouble(fichier.readLong());
                    this.Lastx = NumericDataUtils.convToIntelDouble(fichier.readLong());
                }
                byte fxtype = fichier.readByte();
                switch (fxtype) {
                    case 0: {
                        this.x_units = "Arbitrary";
                        break;
                    }
                    case 1: {
                        this.x_units = "Wavenumber (cm -1)";
                        break;
                    }
                    case 2: {
                        this.x_units = "Micrometers";
                        break;
                    }
                    case 3: {
                        this.x_units = "Nanometers";
                        break;
                    }
                    case 4: {
                        this.x_units = "Seconds";
                        break;
                    }
                    case 5: {
                        this.x_units = "Minuts";
                        break;
                    }
                    case 6: {
                        this.x_units = "Hertz";
                        break;
                    }
                    case 7: {
                        this.x_units = "Kilohertz";
                        break;
                    }
                    case 8: {
                        this.x_units = "Megahertz";
                        break;
                    }
                    case 9: {
                        this.x_units = "Mass (M/z)";
                        break;
                    }
                    case 10: {
                        this.x_units = "Parts per million";
                        break;
                    }
                    case 11: {
                        this.x_units = "Days";
                        break;
                    }
                    case 12: {
                        this.x_units = "Years";
                        break;
                    }
                    case 13: {
                        this.x_units = "Raman Shift (cm -1)";
                        break;
                    }
                    case 14: {
                        this.x_units = "Electron Volt (eV)";
                        break;
                    }
                    case 16: {
                        this.x_units = "Diode Number";
                        break;
                    }
                    case 17: {
                        this.x_units = "Channel";
                        break;
                    }
                    case 18: {
                        this.x_units = "Degrees";
                        break;
                    }
                    case 19: {
                        this.x_units = "Temperature (F)";
                        break;
                    }
                    case 20: {
                        this.x_units = "Temperature (C)";
                        break;
                    }
                    case 21: {
                        this.x_units = "Temperature (K)";
                        break;
                    }
                    case 22: {
                        this.x_units = "Data Points";
                        break;
                    }
                    case 23: {
                        this.x_units = "Milliseconds (mSec)";
                        break;
                    }
                    case 24: {
                        this.x_units = "Microseconds (uSec)";
                        break;
                    }
                    case 25: {
                        this.x_units = "Nanoseconds (nSec)";
                        break;
                    }
                    case 26: {
                        this.x_units = "Gigahertz (GHz)";
                        break;
                    }
                    case 27: {
                        this.x_units = "Centimeters (cm)";
                        break;
                    }
                    case 28: {
                        this.x_units = "Meters (m)";
                        break;
                    }
                    case 29: {
                        this.x_units = "Millimeters (mm)";
                        break;
                    }
                    case 30: {
                        this.x_units = "Hours";
                        break;
                    }
                    case -1: {
                        this.x_units = "(double interferogram)";
                    }
                }
                byte fytype = fichier.readByte();
                switch (fytype) {
                    case 0: {
                        this.y_units = "Arbitrary Intensity";
                        break;
                    }
                    case 1: {
                        this.y_units = "Interfeogram";
                        break;
                    }
                    case 2: {
                        this.y_units = "Absorbance";
                        break;
                    }
                    case 3: {
                        this.y_units = "Kubelka-Munk";
                        break;
                    }
                    case 4: {
                        this.y_units = "Counts";
                        break;
                    }
                    case 5: {
                        this.y_units = "Volts";
                        break;
                    }
                    case 6: {
                        this.y_units = "Degrees";
                        break;
                    }
                    case 7: {
                        this.y_units = "Milliamps";
                        break;
                    }
                    case 8: {
                        this.y_units = "Millimeters";
                        break;
                    }
                    case 9: {
                        this.y_units = "Millivolts";
                        break;
                    }
                    case 10: {
                        this.y_units = "Log (1/R)";
                        break;
                    }
                    case 11: {
                        this.y_units = "Percent";
                        break;
                    }
                    case 12: {
                        this.y_units = "Intensity";
                        break;
                    }
                    case 13: {
                        this.y_units = "Relative Intensity";
                        break;
                    }
                    case 14: {
                        this.y_units = "Energy";
                        break;
                    }
                    case 16: {
                        this.y_units = "Decibel";
                        break;
                    }
                    case 19: {
                        this.y_units = "Temperature (F)";
                        break;
                    }
                    case 20: {
                        this.y_units = "Temperature (C)";
                        break;
                    }
                    case 21: {
                        this.y_units = "Temperature (K)";
                        break;
                    }
                    case 22: {
                        this.y_units = "Index of Refraction [N]";
                        break;
                    }
                    case 23: {
                        this.y_units = "Extinction Coeff. [K]";
                        break;
                    }
                    case 24: {
                        this.y_units = "Real";
                        break;
                    }
                    case 25: {
                        this.y_units = "Imaginary";
                        break;
                    }
                    case 26: {
                        this.y_units = "Complex";
                        break;
                    }
                    case -128: {
                        this.y_units = "Transmission";
                        break;
                    }
                    case -127: {
                        this.y_units = "Reflectance";
                        break;
                    }
                    case -126: {
                        this.y_units = "Arbitrary or Single Beam with Valley Peaks";
                        break;
                    }
                    case -125: {
                        this.y_units = "Emission";
                    }
                }
                if (ftflgs == 0) {
                    fichier.skipBytes(482);
                } else {
                    byte b;
                    fichier.skipBytes(188);
                    int i2 = 0;
                    this.x_units = "";
                    do {
                        b = fichier.readByte();
                        this.x_units = this.x_units + (char)b;
                        ++i2;
                    } while (b != 0);
                    int j = 0;
                    this.y_units = "";
                    do {
                        b = fichier.readByte();
                        this.y_units = this.y_units + (char)b;
                        ++j;
                    } while (b != 0);
                    fichier.skipBytes(294 - i2 - j);
                }
                fichier.skipBytes(32);
                this.My_ZoneVisu.tableau_points = new double[this.Nbpoints];
                if (fexp == 128) {
                    for (i = 0; i < this.Nbpoints; ++i) {
                        this.My_ZoneVisu.tableau_points[i] = NumericDataUtils.convToIntelFloat(fichier.readInt());
                    }
                } else {
                    for (i = 0; i < this.Nbpoints; ++i) {
                        this.My_ZoneVisu.tableau_points[i] = NumericDataUtils.convToIntelInt(fichier.readInt());
                    }
                }
            }
            catch (Exception e) {
                this.Current_Error = "SPC file corrupted";
                return false;
            }
            this.Datatype = "XYDATA";
            return true;
        }
        try {
            String s;
            URL url = new URL(this.getDocumentBase(), filename);
            InputStream stream = url.openStream();
            BufferedReader fichier = new BufferedReader(new InputStreamReader(stream));
            this.texte = new Vector();
            while ((s = fichier.readLine()) != null) {
                this.texte.addElement(s);
            }
            this.nbLignes = this.texte.size();
        }
        catch (Exception e) {
            return false;
        }
        int My_Counter = 0;
        String uneligne = "";
        while (My_Counter < this.nbLignes) {
            try {
                StringTokenizer mon_token;
                do {
                    uneligne = (String)this.texte.elementAt(My_Counter);
                    mon_token = new StringTokenizer(uneligne, " ");
                } while (++My_Counter < this.nbLignes && !mon_token.hasMoreTokens());
                if (!mon_token.hasMoreTokens()) continue;
                String keyword = mon_token.nextToken();
                if (StringDataUtils.compareStrings(keyword, "##TITLE=") == 0) {
                    this.TexteTitre = uneligne.substring(9);
                }
                if (StringDataUtils.compareStrings(keyword, "##FIRSTX=") == 0) {
                    this.Firstx = Double.valueOf(mon_token.nextToken());
                }
                if (StringDataUtils.compareStrings(keyword, "##LASTX=") == 0) {
                    this.Lastx = Double.valueOf(mon_token.nextToken());
                }
                if (StringDataUtils.compareStrings(keyword, "##YFACTOR=") == 0) {
                    this.YFactor = Double.valueOf(mon_token.nextToken());
                }
                if (StringDataUtils.compareStrings(keyword, "##NPOINTS=") == 0) {
                    this.Nbpoints = Integer.valueOf(mon_token.nextToken());
                }
                if (StringDataUtils.compareStrings(keyword, "##XUNITS=") == 0) {
                    this.x_units = uneligne.substring(10);
                }
                if (StringDataUtils.compareStrings(keyword, "##YUNITS=") == 0) {
                    this.y_units = uneligne.substring(10);
                }
                if (StringDataUtils.compareStrings(keyword, "##.OBSERVE") == 0 && StringDataUtils.compareStrings(mon_token.nextToken(), "FREQUENCY=") == 0) {
                    this.nmr_observe_frequency = Double.valueOf(mon_token.nextToken());
                }
                if (StringDataUtils.compareStrings(keyword, "##XYDATA=") == 0 && StringDataUtils.compareStrings(mon_token.nextToken(), "(X++(Y..Y))") == 0) {
                    this.Datatype = "XYDATA";
                }
                if (StringDataUtils.compareStrings(keyword, "##XYDATA=(X++(Y..Y))") == 0) {
                    this.Datatype = "XYDATA";
                }
                if (StringDataUtils.compareStrings(keyword, "##PEAK") == 0 && StringDataUtils.compareStrings(mon_token.nextToken(), "TABLE=") == 0 && StringDataUtils.compareStrings(mon_token.nextToken(), "(XY..XY)") == 0) {
                    this.Datatype = "PEAK TABLE";
                }
                if (StringDataUtils.compareStrings(keyword, "##PEAK") != 0 || StringDataUtils.compareStrings(mon_token.nextToken(), "TABLE=(XY..XY)") != 0) continue;
                this.Datatype = "PEAK TABLE";
            }
            catch (Exception e) {}
        }
        if (this.Datatype.compareTo("UNKNOWN") == 0) {
            return false;
        }
        if (this.Datatype.compareTo("PEAK TABLE") == 0 && this.x_units.compareTo("?") == 0) {
            this.x_units = "M/Z";
        }
        if (StringDataUtils.truncateEndBlanks(this.x_units).compareTo("HZ") == 0 && this.nmr_observe_frequency != (double)this.shitty_starting_constant) {
            this.Firstx /= this.nmr_observe_frequency;
            this.Lastx /= this.nmr_observe_frequency;
            this.x_units = "PPM.";
        }
        if ((resultat_move_points = this.Move_Points_To_Tableau()).compareTo("OK") != 0) {
            this.Current_Error = resultat_move_points;
            return false;
        }
        return true;
    }

    public void Really_Load_File(String chaine_a_lire) {
        this.Firstx = this.shitty_starting_constant;
        this.Lastx = this.shitty_starting_constant;
        this.Nbpoints = this.shitty_starting_constant;
        this.nmr_observe_frequency = this.shitty_starting_constant;
        this.TexteTitre = "";
        this.YFactor = 1.0;
        this.My_ZoneVisu.Draw_Texte("Drawing graphics, please wait...");
        if (this.initFile(chaine_a_lire)) {
            this.My_ZoneVisu.Init_File();
            if (this.Flag_Reverse) {
                this.My_ZoneVisu.Flag_Reverse = true;
            } else {
                this.Flag_Redraw = true;
            }
        } else {
            this.My_ZoneVisu.Draw_Texte("Bad file or filename" + this.Current_Error);
        }
    }

    public void Write_JCamp() {
        String filName2 = this.getParameter("SOURCE_FILE").toLowerCase();
        int ipos = filName2.lastIndexOf("/") + 1;
        if (ipos == -1) {
            ipos = 0;
        }
        filName2 = filName2.substring(ipos, filName2.length());
        System.out.println("FileName : " + filName2);
        try {
            if (this.inNavigator) {
                this.saveDialog.setFile(filName2);
                this.saveDialog.show();
                String dirName = this.saveDialog.getDirectory();
                filName2 = dirName + this.saveDialog.getFile();
            }
            PrintWriter pw = new PrintWriter(new FileWriter(filName2));
            for (int ii = 0; ii < this.texte.size(); ++ii) {
                String newLine = (String)this.texte.elementAt(ii);
                pw.println(newLine);
            }
            pw.close();
        }
        catch (Exception e) {
            System.out.println("\nClient: Unable to write local JCAMP-DX file. " + e);
        }
    }

    public void Do_Zoomin() {
        this.My_ZoneVisu.Draw_Texte("Zooming in, please wait...");
        this.Flag_Zoomin = true;
    }

    public void Do_Zoomback() {
        this.My_ZoneVisu.Draw_Texte("Zooming back, please wait...");
        this.Flag_Zoomback = true;
    }

    public void Do_Zoomout() {
        this.My_ZoneVisu.Draw_Texte("Drawing whole graphics, please wait...");
        this.Flag_Zoomout = true;
    }

    public void Do_Grid() {
        this.My_ZoneVisu.Draw_Texte("Redrawing with grid, please wait...");
        this.Flag_Redraw = true;
    }

    public void Do_Reverse() {
        this.My_ZoneVisu.Draw_Texte("Reversing graphics, please wait...");
        this.My_ZoneVisu.Flag_Reverse = this.Reverse.getState();
        this.Flag_Reverse = true;
    }

    public void Do_Integrate() {
        if (this.Integrate.getState()) {
            this.My_ZoneVisu.Draw_Texte("Integrating peaks, please wait...");
            this.Flag_Integrate = true;
        } else {
            this.My_ZoneVisu.Flag_Integrate = false;
            this.My_ZoneVisu.Draw_Texte("Redrawing graphics, please wait...");
            this.Flag_Redraw = true;
        }
    }

    public void Do_Find_Peak() {
        this.My_ZoneVisu.Draw_Texte("Finding peak, please wait...");
        this.Flag_Find_Peak = true;
    }

    public void Do_Write_JCamp() {
        this.Flag_Write_JCamp = true;
    }

    public void Do_Load_File() {
        Frame Frame_Load_File = (Frame)this.getParent();
        this.Dialogue_Load_File = new SaisieDlg(Frame_Load_File, "Load file...", "Enter the filename :");
        this.Dialogue_Load_File.show();
        this.Flag_Dialogue_File_Enabled = true;
    }

    public boolean handleEvent(Event evt) {
        if (evt.target == this.Load_File && evt.id == 1001) {
            this.Do_Load_File();
            return true;
        }
        if (evt.target == this.Zoom_In && evt.id == 1001) {
            this.Do_Zoomin();
            return true;
        }
        if (evt.target == this.Zoom_Back && evt.id == 1001) {
            this.Do_Zoomback();
            return true;
        }
        if (evt.target == this.Zoom_Out && evt.id == 1001) {
            this.Do_Zoomout();
            return true;
        }
        if (evt.target == this.Reverse && evt.id == 1001) {
            this.Do_Reverse();
            return true;
        }
        if (evt.target == this.Grid && evt.id == 1001) {
            this.Do_Grid();
            return true;
        }
        if (evt.target == this.Integrate && evt.id == 1001) {
            this.Do_Integrate();
            return true;
        }
        if (evt.target == this.Find_Peak && evt.id == 1001) {
            this.Do_Find_Peak();
            return true;
        }
        if (evt.target == this.JCamp && evt.id == 1001) {
            this.Do_Write_JCamp();
            return true;
        }
        return super.handleEvent(evt);
    }
}

