/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Vector;

public final class CommandHistory {
    public static final String ERROR_FLAG = "#??";
    public static final String NOHISTORY_FLAG = "#--";
    static final int DEFAULT_MAX_SIZE = 100;
    private Vector commandList = null;
    private int maxSize = 100;
    private int nextCommand;
    private int cursorPos;
    boolean isOn = true;

    public CommandHistory() {
        this.reset(100);
    }

    public CommandHistory(int maxSize) {
        this.reset(maxSize);
    }

    public void clear() {
        this.reset(this.maxSize);
    }

    public void reset(int maxSize) {
        this.maxSize = maxSize;
        this.commandList = new Vector();
        this.nextCommand = 0;
        this.commandList.add("");
        this.cursorPos = 0;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize == this.maxSize) {
            return;
        }
        if (maxSize < 2) {
            maxSize = 2;
        }
        while (this.nextCommand > maxSize) {
            this.commandList.remove(0);
            --this.nextCommand;
        }
        if (this.nextCommand > maxSize) {
            this.nextCommand = maxSize - 1;
        }
        this.cursorPos = this.nextCommand;
        this.maxSize = maxSize;
    }

    public String getCommandUp() {
        if (this.cursorPos <= 0) {
            return null;
        }
        --this.cursorPos;
        String str = this.getCommand();
        if (str.endsWith(ERROR_FLAG)) {
            this.removeCommand(this.cursorPos--);
        }
        if (this.cursorPos < 0) {
            this.cursorPos = 0;
        }
        return str;
    }

    public String getCommandDown() {
        if (this.cursorPos >= this.nextCommand) {
            return null;
        }
        ++this.cursorPos;
        return this.getCommand();
    }

    private String getCommand() {
        return (String)this.commandList.get(this.cursorPos);
    }

    public void addCommand(String strCommand) {
        int i;
        if (!this.isOn && !strCommand.endsWith(ERROR_FLAG)) {
            return;
        }
        while ((i = strCommand.indexOf("\n")) >= 0) {
            String str = strCommand.substring(0, i);
            if (str.length() > 0) {
                this.addCommandLine(str);
            }
            strCommand = strCommand.substring(i + 1);
        }
        if (strCommand.length() > 0) {
            this.addCommandLine(strCommand);
        }
    }

    public String getSetHistory(int n) {
        this.isOn = n == -2 ? this.isOn : true;
        switch (n) {
            case 0: {
                this.isOn = false;
            }
            case -2147483648: 
            case -2: {
                this.clear();
                return "";
            }
            case -1: {
                return this.getCommandUp();
            }
            case 1: {
                return this.getCommandDown();
            }
        }
        if (n < 0) {
            this.setMaxSize(-2 - n);
            return "";
        }
        n = Math.max(this.nextCommand - n, 0);
        String str = "";
        for (int i = n; i < this.nextCommand; ++i) {
            str = str + this.commandList.get(i) + "\n";
        }
        return str;
    }

    public String removeCommand() {
        return this.removeCommand(this.nextCommand - 1);
    }

    public String removeCommand(int n) {
        if (n < 0 || n >= this.nextCommand) {
            return "";
        }
        String str = (String)this.commandList.get(n);
        this.commandList.remove(n);
        --this.nextCommand;
        return str;
    }

    private void addCommandLine(String command) {
        if (command == null || command.length() == 0) {
            return;
        }
        if (command.endsWith(NOHISTORY_FLAG)) {
            return;
        }
        if (this.nextCommand >= this.maxSize) {
            this.commandList.remove(0);
            this.nextCommand = this.maxSize - 1;
        }
        this.commandList.add(this.nextCommand, command);
        ++this.nextCommand;
        this.cursorPos = this.nextCommand;
        this.commandList.add(this.nextCommand, "");
    }
}

