/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Mps;
import org.jmol.viewer.ShapeRenderer;

abstract class MpsRenderer
extends ShapeRenderer {
    MpsRenderer() {
    }

    void render() {
        if (this.shape == null) {
            return;
        }
        Mps mcps = (Mps)this.shape;
        int m = mcps.getMpsmodelCount();
        while (--m >= 0) {
            Mps.Mpsmodel mcpsmodel = mcps.getMpsmodel(m);
            if ((mcpsmodel.modelVisibilityFlags & this.shape.myVisibilityFlag) == 0) continue;
            int c = mcpsmodel.getMpspolymerCount();
            while (--c >= 0) {
                Mps.Mpspolymer mpspolymer = mcpsmodel.getMpspolymer(c);
                if (mpspolymer.monomerCount < 2) continue;
                this.renderMpspolymer(mpspolymer, this.shape.myVisibilityFlag);
            }
        }
    }

    abstract void renderMpspolymer(Mps.Mpspolymer var1, int var2);

    final boolean[] calcIsSpecials(int monomerCount, Monomer[] monomers) {
        boolean[] isSpecials = this.viewer.allocTempBooleans(monomerCount + 1);
        int i = monomerCount;
        while (--i >= 0) {
            isSpecials[i] = monomers[i].isHelixOrSheet();
        }
        isSpecials[monomerCount] = isSpecials[monomerCount - 1];
        return isSpecials;
    }

    final boolean[] calcIsHelix(int monomerCount, Monomer[] monomers) {
        boolean[] isHelix = this.viewer.allocTempBooleans(monomerCount + 1);
        int i = monomerCount;
        while (--i >= 0) {
            isHelix[i] = monomers[i].isHelix();
        }
        isHelix[monomerCount] = isHelix[monomerCount - 1];
        return isHelix;
    }

    final Point3i[] calcScreenLeadMidpoints(int monomerCount, Point3f[] leadMidpoints) {
        int count = monomerCount + 1;
        Point3i[] leadMidpointScreens = this.viewer.allocTempScreens(count);
        int i = count;
        while (--i >= 0) {
            this.viewer.transformPoint(leadMidpoints[i], leadMidpointScreens[i]);
        }
        return leadMidpointScreens;
    }

    final void renderRopeSegment(short colix, short[] mads, int i, int monomerCount, Monomer[] monomers, Point3i[] leadMidpointScreens, boolean[] isSpecials) {
        this.renderRopeSegment2(colix, mads, i, i, monomerCount, monomers, leadMidpointScreens, isSpecials);
    }

    final void renderRopeSegment2(short colix, short[] mads, int i, int imad, int monomerCount, Monomer[] monomers, Point3i[] leadMidpointScreens, boolean[] isSpecials) {
        int madEnd;
        int iNext2;
        int iNext1;
        int iPrev1 = i - 1;
        if (iPrev1 < 0) {
            iPrev1 = 0;
        }
        if ((iNext1 = i + 1) > monomerCount) {
            iNext1 = monomerCount;
        }
        if ((iNext2 = i + 2) > monomerCount) {
            iNext2 = monomerCount;
        }
        int madBeg = madEnd = mads[imad];
        int madThis = madEnd;
        if (isSpecials != null) {
            if (!isSpecials[iPrev1]) {
                madBeg = (mads[iPrev1] + madThis) / 2;
            }
            if (!isSpecials[iNext1]) {
                madEnd = (mads[iNext1] + madThis) / 2;
            }
        }
        short diameterBeg = 0;
        try {
            diameterBeg = this.viewer.scaleToScreen(leadMidpointScreens[i].z, madBeg);
        }
        catch (Exception e) {
            System.out.println(i);
        }
        short diameterEnd = this.viewer.scaleToScreen(leadMidpointScreens[iNext1].z, madEnd);
        short diameterMid = this.viewer.scaleToScreen(monomers[i].getLeadAtom().getScreenZ(), madThis);
        this.g3d.fillHermite(colix, monomers[i].isNucleic() ? 4 : 7, diameterBeg, diameterMid, diameterEnd, leadMidpointScreens[iPrev1], leadMidpointScreens[i], leadMidpointScreens[iNext1], leadMidpointScreens[iNext2]);
    }
}

