/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.text.DecimalFormat;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class StyleManager {
    Viewer viewer;
    static final String DEFAULT_HELP_PATH = "http://www.stolaf.edu/academics/chemapps/jmol/docs/index.htm?search=";
    static final int DEFAULT_PERCENT_VDW_ATOM = 20;
    int percentVdwAtom = 20;
    static final float DEFAULT_BOND_RADIUS = 0.15f;
    short marBond = (short)150;
    static final float DEFAULT_BOND_TOLERANCE = 0.45f;
    float bondTolerance = 0.45f;
    static final float DEFAULT_MIN_BOND_DISTANCE = 0.4f;
    float minBondDistance = 0.4f;
    int defaultVectorMad = 0;
    String measureDistanceUnits = "nanometers";
    String propertyStyleString = "";
    boolean zeroBasedXyzRasmol = false;
    int pointsLabelFontSize = 13;
    int labelOffsetX = 4;
    int labelOffsetY = 4;
    static String[] formattingStrings = new String[]{"0", "0.0", "0.00", "0.000", "0.0000", "0.00000", "0.000000", "0.0000000", "0.00000000", "0.000000000"};
    DecimalFormat[] formatters;

    StyleManager(Viewer viewer) {
        this.viewer = viewer;
    }

    String getDefaultHelpPath() {
        return DEFAULT_HELP_PATH;
    }

    void setCommonDefaults() {
        this.viewer.zoomToPercent(100.0f);
        this.viewer.setPerspectiveDepth(true);
        this.viewer.setPercentVdwAtom(20);
        this.viewer.setBondTolerance(0.45f);
        this.viewer.setMinBondDistance(0.4f);
        this.viewer.setMarBond((short)150);
    }

    void setJmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setDefaultColors("jmol");
        this.viewer.setAxesOrientationRasmol(false);
        this.viewer.setZeroBasedXyzRasmol(false);
    }

    void setRasmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setDefaultColors("rasmol");
        this.viewer.setAxesOrientationRasmol(true);
        this.viewer.setZeroBasedXyzRasmol(true);
        this.viewer.setPercentVdwAtom(0);
        this.viewer.setMarBond((short)1);
    }

    void setPercentVdwAtom(int percentVdwAtom) {
        if (percentVdwAtom != this.percentVdwAtom) {
            Logger.info("default percent van der Waal radius set to " + percentVdwAtom);
        }
        this.percentVdwAtom = percentVdwAtom;
    }

    void setMarBond(short marBond) {
        if (marBond != this.marBond) {
            Logger.info("default bond radius set to " + (float)marBond / 1000.0f);
        }
        this.marBond = marBond;
    }

    void setBondTolerance(float bondTolerance) {
        if (bondTolerance != this.bondTolerance) {
            Logger.info("default bond tolerance set to " + bondTolerance);
        }
        this.bondTolerance = bondTolerance;
    }

    void setMinBondDistance(float minBondDistance) {
        if (minBondDistance != this.minBondDistance) {
            Logger.info("default minimum bond distance set to " + minBondDistance);
        }
        this.minBondDistance = minBondDistance;
    }

    void setDefaultVectorMad(int mad) {
        this.defaultVectorMad = mad;
    }

    boolean setMeasureDistanceUnits(String units) {
        if (units.equalsIgnoreCase("angstroms")) {
            this.measureDistanceUnits = "angstroms";
        } else if (units.equalsIgnoreCase("nanometers") || units.equalsIgnoreCase("nm")) {
            this.measureDistanceUnits = "nanometers";
        } else if (units.equalsIgnoreCase("picometers") || units.equalsIgnoreCase("pm")) {
            this.measureDistanceUnits = "picometers";
        } else {
            return false;
        }
        return true;
    }

    void setPropertyStyleString(String s) {
        this.propertyStyleString = s;
    }

    void setZeroBasedXyzRasmol(boolean zeroBasedXyzRasmol) {
        this.zeroBasedXyzRasmol = zeroBasedXyzRasmol;
    }

    float getBondTolerance() {
        return this.bondTolerance;
    }

    float getMinBondDistance() {
        return this.minBondDistance;
    }

    void setLabelFontSize(int points) {
        this.pointsLabelFontSize = points <= 0 ? 13 : points;
    }

    void setLabelOffset(int offsetX, int offsetY) {
        this.labelOffsetX = offsetX;
        this.labelOffsetY = offsetY;
    }

    String formatDecimal(float value, int decimalDigits) {
        DecimalFormat formatter;
        if (decimalDigits < 0) {
            return "" + value;
        }
        if (this.formatters == null) {
            this.formatters = new DecimalFormat[formattingStrings.length];
        }
        if (decimalDigits >= formattingStrings.length) {
            decimalDigits = formattingStrings.length - 1;
        }
        if ((formatter = this.formatters[decimalDigits]) == null) {
            formatter = this.formatters[decimalDigits] = new DecimalFormat(formattingStrings[decimalDigits]);
        }
        return formatter.format(value);
    }

    String getStandardLabelFormat() {
        int modelCount = this.viewer.getModelCount();
        String strLabel = this.viewer.getChainCount() > modelCount ? "[%n]%r:%c.%a" : (this.viewer.getGroupCount() <= modelCount ? "%e%i" : "[%n]%r.%a");
        if (this.viewer.getModelCount() > 1) {
            strLabel = strLabel + "/%M";
        }
        return strLabel;
    }

    void setCrystallographicDefaults() {
        this.viewer.setShapeSize(17, 200);
        this.viewer.setShapeSize(19, -1);
        this.viewer.setAxesModeUnitCell(true);
        this.viewer.setPerspectiveDepth(false);
    }
}

