/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.openscience.cdk.tools.LoggingTool;

public class JCPPropertyHandler {
    private static JCPPropertyHandler jcpPropsHandler = null;
    private LoggingTool logger = new LoggingTool((Object)this);
    private Properties currentProperties = null;
    private File userPropsFile = null;
    private File uhome = null;
    private File ujcpdir = null;
    private ResourceBundle guiDefinition = null;
    private ResourceBundle resources;
    private Properties shortCutProps;
    static /* synthetic */ Class class$org$openscience$cdk$applications$jchempaint$JCPPropertyHandler;

    private JCPPropertyHandler() {
    }

    public static JCPPropertyHandler getInstance() {
        if (jcpPropsHandler == null) {
            jcpPropsHandler = new JCPPropertyHandler();
        }
        return jcpPropsHandler;
    }

    public Properties getJCPProperties() {
        if (this.currentProperties == null) {
            this.reloadProperties();
        }
        return this.currentProperties;
    }

    public void reloadProperties() {
        Properties applicationProps = null;
        Properties defaultProps = null;
        try {
            InputStream defaultStream = (class$org$openscience$cdk$applications$jchempaint$JCPPropertyHandler == null ? (class$org$openscience$cdk$applications$jchempaint$JCPPropertyHandler = JCPPropertyHandler.class$("org.openscience.cdk.applications.jchempaint.JCPPropertyHandler")) : class$org$openscience$cdk$applications$jchempaint$JCPPropertyHandler).getResourceAsStream("resources/text/JChemPaintResources.properties");
            defaultProps = new Properties();
            defaultProps.load(defaultStream);
            defaultStream.close();
            this.logger.info((Object)"Loaded properties from jar");
        }
        catch (Exception exception) {
            this.logger.error((Object)"There was a problem retrieving JChemPaint's default properties.");
            this.logger.debug((Object)exception);
        }
        try {
            applicationProps = new Properties(defaultProps);
            FileInputStream appStream = new FileInputStream(this.getUserPropsFile());
            applicationProps.load(appStream);
            appStream.close();
            this.logger.info((Object)"Loaded user properties from file");
        }
        catch (FileNotFoundException exception) {
            this.logger.warn((Object)"User does not have localized properties in ");
        }
        catch (Exception exception) {
            this.logger.error((Object)"There was a problem retrieving the user properties from file");
            this.logger.debug((Object)exception);
        }
        this.currentProperties = applicationProps;
    }

    public void saveProperties() {
        try {
            FileOutputStream appStream = new FileOutputStream(this.getUserPropsFile());
            this.currentProperties.store(appStream, null);
            appStream.flush();
            appStream.close();
            this.logger.info((Object)"Properties save to ", (Object)this.getUserPropsFile());
        }
        catch (Exception exception) {
            this.logger.error((Object)"An error has occured while storing properties");
            this.logger.error((Object)"to file ");
            this.logger.debug((Object)exception);
        }
    }

    public File getUserHome() {
        if (this.uhome == null) {
            try {
                this.uhome = new File(System.getProperty("user.home"));
            }
            catch (Exception exc) {
                this.logger.error((Object)"Could not read a system property. Failing!");
                this.logger.debug((Object)exc);
            }
        }
        return this.uhome;
    }

    public File getJChemPaintDir() {
        if (this.ujcpdir == null) {
            try {
                this.ujcpdir = new File(this.getUserHome(), ".jchempaint");
                this.ujcpdir.mkdirs();
            }
            catch (Exception exc) {
                this.logger.error((Object)"Could read a JChemPaint dir. I might be in a sandbox.");
                this.logger.debug((Object)exc);
            }
        }
        return this.ujcpdir;
    }

    public File getUserPropsFile() {
        if (this.userPropsFile == null) {
            try {
                this.userPropsFile = new File(this.getJChemPaintDir(), "properties");
            }
            catch (Exception exc) {
                this.logger.error((Object)"Could not read a system property. I might be in a sandbox.");
                this.logger.debug((Object)exc);
            }
        }
        return this.userPropsFile;
    }

    public ResourceBundle getGUIDefinition() {
        if (this.guiDefinition == null) {
            String guiString = null;
            try {
                guiString = System.getProperty("gui");
            }
            catch (Exception exc) {
                this.logger.error((Object)"Could not read a system property. I might be in a sandbox.");
            }
            if (guiString == null) {
                guiString = "stable";
            }
            this.guiDefinition = this.getGUIDefinition(guiString);
        }
        return this.guiDefinition;
    }

    public ResourceBundle getGUIDefinition(String guiString) {
        try {
            String resource = "org.openscience.cdk.applications.jchempaint.resources.text.JCPGUI_" + guiString;
            this.guiDefinition = ResourceBundle.getBundle(resource, Locale.getDefault());
        }
        catch (Exception exc) {
            this.logger.error((Object)("Could not read a GUI definition: " + exc.getMessage()));
            this.logger.debug((Object)exc);
        }
        return this.guiDefinition;
    }

    public Properties getJCPShort_Cuts() {
        if (this.shortCutProps == null) {
            try {
                String propertiesFile = "org/openscience/cdk/applications/jchempaint/resources/text/JCPShort_Cuts.properties";
                this.shortCutProps = new Properties();
                InputStream appStream = this.getClass().getClassLoader().getResourceAsStream(propertiesFile);
                this.shortCutProps.load(appStream);
                appStream.close();
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.shortCutProps;
    }

    public ResourceBundle getResources() {
        if (this.resources == null) {
            try {
                String resource = "org.openscience.cdk.applications.jchempaint.resources.text.JChemPaintResources";
                this.resources = ResourceBundle.getBundle(resource);
            }
            catch (Exception exc) {
                this.logger.error((Object)"Could not read the resources.");
                this.logger.debug((Object)exc);
            }
        }
        return this.resources;
    }

    public URL getResource(String key) {
        String name = this.getResourceString(key);
        this.logger.debug((Object)"resource name: ", (Object)name);
        if (name != null) {
            URL url = this.getClass().getResource(name);
            return url;
        }
        this.logger.error((Object)"ResourceString is null for: ", (Object)key);
        return null;
    }

    public String getResourceString(String key) {
        String str;
        try {
            str = this.getResources().getString(key);
        }
        catch (MissingResourceException mre) {
            this.logger.error((Object)"Could not find resource: ", (Object)mre.getMessage());
            this.logger.debug((Object)mre);
            str = null;
        }
        return str;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

