/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import javax.swing.undo.UndoableEdit;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.undoredo.ChangeAtomSymbolEdit;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.controller.Controller2D;
import org.openscience.cdk.controller.Controller2DModel;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;

public class ChangeAtomSymbolAction
extends JCPAction {
    private static final long serialVersionUID = -8502905723573311893L;

    public void actionPerformed(ActionEvent event) {
        logger.debug((Object)"About to change atom type of relevant atom!");
        JChemPaintModel jcpm = this.jcpPanel.getJChemPaintModel();
        if (jcpm != null) {
            Controller2DModel c2dm = jcpm.getControllerModel();
            IAtom atomInRange = null;
            IChemObject object = this.getSource(event);
            logger.debug((Object)"Source of call: ", (Object)object);
            atomInRange = object instanceof IAtom ? (IAtom)object : jcpm.getRendererModel().getHighlightedAtom();
            String formerSymbol = atomInRange.getSymbol();
            String s = event.getActionCommand();
            String symbol = s.substring(s.indexOf("@") + 1);
            atomInRange.setSymbol(symbol);
            c2dm.setDrawElement(symbol);
            try {
                IsotopeFactory.getInstance((IChemObjectBuilder)atomInRange.getBuilder()).configure(atomInRange);
            }
            catch (Exception exception) {
                logger.error((Object)"Error while configuring atom");
                logger.debug((Object)exception);
            }
            ((Controller2D)this.jcpPanel.getDrawingPanel().getMouseListeners()[0]).updateAtom(MoleculeSetManipulator.getAllInOneContainer((IMoleculeSet)jcpm.getChemModel().getMoleculeSet()), atomInRange);
            ChangeAtomSymbolEdit edit = new ChangeAtomSymbolEdit(atomInRange, formerSymbol, symbol);
            this.jcpPanel.getUndoSupport().postEdit((UndoableEdit)edit);
            jcpm.fireChange();
        }
    }
}

