/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.jchempaint.dialogs.TextViewDialog;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.tools.HydrogenAdder;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class CreateInChIAction
extends JCPAction {
    private static final long serialVersionUID = -4886982931009753347L;
    TextViewDialog dialog = null;
    JFrame frame = null;

    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)"Trying to create InChI: ", (Object)this.type);
        if (this.dialog == null) {
            this.dialog = new TextViewDialog(this.frame, "InChI", null, false, 40, 2);
        }
        InChIGeneratorFactory factory = null;
        try {
            factory = new InChIGeneratorFactory();
        }
        catch (CDKException cdke) {
            String message = "Error loading InChI library: " + cdke.getMessage();
            logger.error((Object)message);
            logger.debug((Object)cdke);
            this.dialog.setMessage("Error", message);
        }
        if (factory != null) {
            ChemModel model = (ChemModel)this.jcpPanel.getJChemPaintModel().getChemModel();
            List containersList = ChemModelManipulator.getAllAtomContainers((IChemModel)model);
            StringBuffer dialogText = new StringBuffer();
            String eol = System.getProperty("line.separator");
            ArrayList<IAtomContainer> molecules = new ArrayList<IAtomContainer>();
            Iterator iterator = containersList.iterator();
            while (iterator.hasNext()) {
                IAtomContainer ac = (IAtomContainer)iterator.next();
                if (ac.getAtomCount() <= 0) continue;
                molecules.add(ac);
            }
            for (int i = 0; i < molecules.size(); ++i) {
                if (molecules.size() > 1) {
                    dialogText.append("Structure #" + (i + 1) + eol);
                }
                IAtomContainer container = (IAtomContainer)molecules.get(i);
                try {
                    HydrogenAdder hAdd = new HydrogenAdder();
                    hAdd.addImplicitHydrogensToSatisfyValency(container);
                    InChIGenerator inchiGen = factory.getInChIGenerator(container);
                    INCHI_RET ret = inchiGen.getReturnStatus();
                    String inchi = inchiGen.getInchi();
                    String auxinfo = inchiGen.getAuxInfo();
                    String message = inchiGen.getMessage();
                    if (ret == INCHI_RET.OKAY) {
                        dialogText.append(inchi + eol + auxinfo + eol + eol);
                        continue;
                    }
                    if (ret == INCHI_RET.WARNING) {
                        dialogText.append(inchi + eol + auxinfo + eol + "Warning: " + message + eol + eol);
                        continue;
                    }
                    dialogText.append("InChI generation failed (" + ret.toString() + ")" + eol + message + eol + eol);
                    continue;
                }
                catch (CDKException cdke) {
                    dialogText.append("InChI generation failed: " + cdke.getMessage() + eol + eol);
                }
            }
            this.dialog.setMessage("Generated InChI:", dialogText.toString());
        }
        this.dialog.setVisible(true);
    }
}

