/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.applications.jchempaint.JCPPropertyHandler;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.JChemPaintPanel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.jchempaint.io.IJCPFileFilter;
import org.openscience.cdk.applications.jchempaint.io.JCPFileView;
import org.openscience.cdk.applications.jchempaint.io.JCPSaveFileFilter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.CDKSourceCodeWriter;
import org.openscience.cdk.io.IChemObjectWriter;
import org.openscience.cdk.io.MDLWriter;
import org.openscience.cdk.io.SMILESWriter;
import org.openscience.cdk.io.SVGWriter;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.listener.SwingGUIListener;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class SaveAsAction
extends JCPAction {
    private static final long serialVersionUID = -5138502232232716970L;
    protected IChemObjectWriter cow;
    protected static String type = null;
    private FileFilter currentFilter = null;
    static /* synthetic */ Class class$java$io$Writer;

    public SaveAsAction() {
    }

    public SaveAsAction(JChemPaintPanel jcpPanel, boolean isPopupAction) {
        super(jcpPanel, "", isPopupAction);
    }

    public void actionPerformed(ActionEvent event) {
        JChemPaintModel jcpm = this.jcpPanel.getJChemPaintModel();
        if (jcpm == null) {
            String error = "Nothing to save.";
            JOptionPane.showMessageDialog(this.jcpPanel, error);
        } else {
            this.saveAs(event);
        }
    }

    protected void saveAs(ActionEvent event) {
        int ready = 1;
        while (ready == 1) {
            String error;
            String error2;
            JChemPaintModel jcpm = this.jcpPanel.getJChemPaintModel();
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(this.jcpPanel.getCurrentWorkDirectory());
            JCPSaveFileFilter.addChoosableFileFilters(chooser);
            if (this.jcpPanel.getCurrentSaveFileFilter() != null) {
                // empty if block
            }
            if (this.currentFilter != null) {
                chooser.setFileFilter(this.currentFilter);
            }
            chooser.setFileView(new JCPFileView());
            int returnVal = chooser.showSaveDialog(this.jcpPanel);
            IChemObject object = this.getSource(event);
            this.currentFilter = chooser.getFileFilter();
            if (returnVal == 1) {
                ready = 0;
            }
            if (returnVal != 0) continue;
            type = ((IJCPFileFilter)((Object)this.currentFilter)).getType();
            File outFile = chooser.getSelectedFile();
            ready = outFile.exists() ? JOptionPane.showConfirmDialog(null, "File " + outFile.getName() + " already exists. Do you want to overwrite it?", "File already exists", 0) : 0;
            if (ready != 0) continue;
            IChemModel model = jcpm.getChemModel();
            if (object == null) {
                try {
                    if (type.equals("mol")) {
                        this.saveAsMol(model, outFile);
                    } else if (type.equals("cml")) {
                        this.saveAsCML2((IChemObject)model, outFile);
                    } else if (type.equals("smiles")) {
                        this.saveAsSMILES(model, outFile);
                    } else if (type.equals("svg")) {
                        this.saveAsSVG(model, outFile);
                    } else if (type.equals("cdk")) {
                        this.saveAsCDKSourceCode(model, outFile);
                    } else {
                        error2 = "Cannot save file in this format: " + type;
                        logger.error((Object)error2);
                        JOptionPane.showMessageDialog(this.jcpPanel, error2);
                        return;
                    }
                    jcpm.resetIsModified();
                }
                catch (Exception exc) {
                    error = "Error while writing file: " + exc.getMessage();
                    logger.error((Object)error);
                    logger.debug((Object)exc);
                    JOptionPane.showMessageDialog(this.jcpPanel, error);
                }
            } else if (object instanceof Reaction) {
                try {
                    if (type.equals("cml")) {
                        this.saveAsCML2(object, outFile);
                    } else {
                        error2 = "Cannot save reaction in this format: " + type;
                        logger.error((Object)error2);
                        JOptionPane.showMessageDialog(this.jcpPanel, error2);
                    }
                }
                catch (Exception exc) {
                    error = "Error while writing file: " + exc.getMessage();
                    logger.error((Object)error);
                    logger.debug((Object)exc);
                    JOptionPane.showMessageDialog(this.jcpPanel, error);
                }
            }
            this.jcpPanel.setCurrentWorkDirectory(chooser.getCurrentDirectory());
            this.jcpPanel.setCurrentSaveFileFilter(chooser.getFileFilter());
            this.jcpPanel.setIsAlreadyAFile(outFile);
            this.jcpPanel.getJChemPaintModel().setTitle(outFile.getName());
            ((JFrame)this.jcpPanel.getParent().getParent().getParent().getParent()).setTitle(outFile.getName());
        }
    }

    private boolean askIOSettings() {
        return JCPPropertyHandler.getInstance().getJCPProperties().getProperty("askForIOSettings", "true").equals("true");
    }

    protected void saveAsMol(IChemModel model, File outFile) throws Exception {
        logger.info((Object)"Saving the contents in a MDL molfile file...");
        String fileName = outFile.toString();
        if (!fileName.endsWith(".mol")) {
            fileName = fileName + ".mol";
            outFile = new File(fileName);
        }
        outFile = new File(fileName);
        this.cow = new MDLWriter((Writer)new FileWriter(outFile));
        if (this.cow != null && this.askIOSettings()) {
            this.cow.addChemObjectIOListener((IChemObjectIOListener)new SwingGUIListener((Component)this.jcpPanel, 4));
        }
        IMoleculeSet som = model.getMoleculeSet();
        this.cow.write((IChemObject)som);
        this.cow.close();
    }

    protected void saveAsCML2(IChemObject object, File outFile) throws Exception {
        if ((double)Float.parseFloat(System.getProperty("java.specification.version")) < 1.5) {
            JOptionPane.showMessageDialog(null, "For saving as CML you need Java 1.5 or higher!");
            return;
        }
        logger.info((Object)"Saving the contents in a CML 2.0 file...");
        String fileName = outFile.toString();
        if (!fileName.endsWith(".cml")) {
            fileName = fileName + ".cml";
            outFile = new File(fileName);
        }
        FileWriter sw = new FileWriter(outFile);
        Class<?> cmlWriterClass = this.getClass().getClassLoader().loadClass("org.openscience.cdk.io.CMLWriter");
        if (cmlWriterClass != null) {
            this.cow = (IChemObjectWriter)cmlWriterClass.newInstance();
            Constructor<?> constructor = this.cow.getClass().getConstructor(class$java$io$Writer == null ? (class$java$io$Writer = SaveAsAction.class$("java.io.Writer")) : class$java$io$Writer);
            this.cow = (IChemObjectWriter)constructor.newInstance(sw);
        } else {
            this.cow = new MDLWriter((Writer)sw);
        }
        if (this.cow != null && this.askIOSettings()) {
            this.cow.addChemObjectIOListener((IChemObjectIOListener)new SwingGUIListener((Component)this.jcpPanel, 4));
        }
        this.cow.write(object);
        this.cow.close();
        sw.close();
    }

    protected void saveAsSMILES(IChemModel model, File outFile) throws Exception {
        logger.info((Object)"Saving the contents in SMILES format...");
        String fileName = outFile.toString();
        if (!fileName.endsWith(".smi")) {
            fileName = fileName + ".smi";
        }
        this.cow = new SMILESWriter((Writer)new FileWriter(outFile));
        if (this.cow != null && this.askIOSettings()) {
            this.cow.addChemObjectIOListener((IChemObjectIOListener)new SwingGUIListener((Component)this.jcpPanel, 4));
        }
        IMoleculeSet som = model.getMoleculeSet();
        this.cow.write((IChemObject)som);
        this.cow.close();
    }

    protected void saveAsCDKSourceCode(IChemModel model, File outFile) throws Exception {
        IAtomContainer ac;
        logger.info((Object)"Saving the contents as a CDK source code file...");
        String fileName = outFile.toString();
        if (!fileName.endsWith(".cdk")) {
            fileName = fileName + ".cdk";
            outFile = new File(fileName);
        }
        this.cow = new CDKSourceCodeWriter((Writer)new FileWriter(outFile));
        if (this.cow != null && this.askIOSettings()) {
            this.cow.addChemObjectIOListener((IChemObjectIOListener)new SwingGUIListener((Component)this.jcpPanel, 4));
        }
        if ((ac = ChemModelManipulator.getAllInOneContainer((IChemModel)model)) != null) {
            this.cow.write((IChemObject)new Molecule(ac));
            this.cow.close();
        } else {
            System.err.println("AC == null!");
        }
    }

    protected void saveAsSVG(IChemModel model, File outFile) throws Exception {
        IAtomContainer ac;
        logger.info((Object)"Saving the contents as a SVG file...");
        this.cow = new SVGWriter((Writer)new FileWriter(outFile));
        if (this.cow != null && this.askIOSettings()) {
            this.cow.addChemObjectIOListener((IChemObjectIOListener)new SwingGUIListener((Component)this.jcpPanel, 4));
        }
        if ((ac = ChemModelManipulator.getAllInOneContainer((IChemModel)model)) != null) {
            this.cow.write((IChemObject)((AtomContainer)ac.clone()));
            this.cow.close();
        } else {
            System.err.println("AC == null!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

