/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.jchempaint.dialogs.TextViewDialog;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.libio.cml.Convertor;
import org.xmlcml.cml.element.CMLCml;

public class ShowChemObjectDumpAction
extends JCPAction {
    private static final long serialVersionUID = 3112715648384115740L;
    TextViewDialog dialog = null;

    public void actionPerformed(ActionEvent event) {
        IChemObject object = this.getSource(event);
        JFrame frame = new JFrame();
        if (this.dialog == null) {
            this.dialog = new TextViewDialog(frame, "IChemObject Dump", new Dimension(500, 300));
        }
        Convertor convertor = new Convertor(false, null);
        try {
            CMLCml cmlDOM = new CMLCml();
            if (object instanceof IMolecule) {
                cmlDOM = convertor.cdkMoleculeToCMLMolecule((IMolecule)object);
            } else if (object instanceof IAtom) {
                cmlDOM = convertor.cdkAtomToCMLAtom((IAtom)object);
            } else if (object instanceof IBond) {
                cmlDOM = convertor.cdkBondToCMLBond((IBond)object);
            }
            this.dialog.setText(cmlDOM.toXML());
        }
        catch (Exception exception) {
            String message = "CML Writer cannot write ChemOject: " + object.getClass().getName();
            logger.error((Object)message);
            logger.debug((Object)exception);
            this.dialog.setText(message);
        }
        this.dialog.setVisible(true);
    }
}

