/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.guha.rcdk.util.Misc;
import org.guha.rcdk.view.panels.JmolPanel;
import org.guha.rcdk.view.panels.Render2DPanel;
import org.guha.rcdk.view.table.MyTable;
import org.guha.rcdk.view.table.StructureTableCellEditor2D;
import org.guha.rcdk.view.table.StructureTableCellRenderer2D;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class ViewMolecule2DDataTable {
    private static int STRUCTURE_COL = 0;
    private IAtomContainer[] molecules;
    private String[] cnames;
    private Object[][] tabledata;
    private int fontSize = 14;
    private int cellx = 200;
    private int celly = 200;
    private int ncol;
    private int nrow;
    private JFrame frame;

    public ViewMolecule2DDataTable(String[] fnames, String[] cnames, Object[][] tabledata) {
        try {
            this.molecules = Misc.loadMolecules(fnames, true, true, true);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.frame = new JFrame("Table of Molecules");
        this.frame.addWindowListener(new ApplicationCloser());
        this.cnames = cnames;
        this.tabledata = tabledata;
    }

    public ViewMolecule2DDataTable(IAtomContainer[] molecules, String[] cnames, Object[][] tabledata) {
        this.frame = new JFrame("Table of Molecules");
        this.frame.addWindowListener(new ApplicationCloser());
        this.cnames = cnames;
        this.tabledata = tabledata;
        this.molecules = molecules;
    }

    public void setCellX(int cellx) {
        this.cellx = cellx;
    }

    public void setCellY(int celly) {
        this.celly = celly;
    }

    public void setFontSize(int f) {
        this.fontSize = f;
    }

    public void display() {
        int i;
        this.ncol = this.cnames.length;
        this.nrow = this.molecules.length;
        Object[][] data = new Object[this.molecules.length][this.cnames.length];
        for (i = 0; i < this.molecules.length; ++i) {
            try {
                CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)this.molecules[i]);
                this.molecules[i] = Misc.getMoleculeWithCoordinates(this.molecules[i]);
                this.molecules[i] = AtomContainerManipulator.removeHydrogens((IAtomContainer)this.molecules[i]);
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            data[i][0] = new Render2DPanel(this.molecules[i], null, this.cellx, this.celly, false);
        }
        for (i = 0; i < this.molecules.length; ++i) {
            for (int j = 1; j < this.cnames.length; ++j) {
                data[i][j] = this.tabledata[i][j - 1];
            }
        }
        MyTable mtable = new MyTable(new Render2DPanelJTableModel(data, this.cnames));
        mtable.setShowGrid(true);
        mtable.getTableHeader().setFont(new Font("Lucida", 1, this.fontSize));
        mtable.getTableHeader().setReorderingAllowed(false);
        for (int i2 = 0; i2 < this.molecules.length; ++i2) {
            mtable.setRowHeight(i2, this.celly);
        }
        mtable.getColumnModel().getColumn(STRUCTURE_COL).setPreferredWidth(this.cellx);
        mtable.getColumnModel().addColumnModelListener(new Render2DColumnModelListener(mtable));
        mtable.setColumnSelectionAllowed(true);
        mtable.setRowSelectionAllowed(true);
        JScrollPane scrollpane = new JScrollPane(mtable);
        scrollpane.setHorizontalScrollBarPolicy(32);
        mtable.setPreferredScrollableViewportSize(new Dimension(this.ncol * this.cellx, this.nrow));
        this.frame.getContentPane().add(scrollpane);
        TableColumn col = mtable.getColumnModel().getColumn(0);
        col.setCellRenderer(new StructureTableCellRenderer2D());
        col.setCellEditor(new StructureTableCellEditor2D());
        RowLabelRenderer myRowRenderer = new RowLabelRenderer();
        for (int i3 = 1; i3 < this.ncol; ++i3) {
            col = mtable.getColumnModel().getColumn(i3);
            col.setCellRenderer(myRowRenderer);
        }
        this.frame.pack();
        this.frame.setSize(this.cellx * (this.ncol > 3 ? 3 : this.ncol), this.celly);
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        String home = "/Users/rguha/";
        String[] fname = new String[]{home + "src/R/trunk/rcdk/data/dan001.sdf", home + "src/R/trunk/rcdk/data/dan002.sdf", home + "src/R/trunk/rcdk/data/dan003.sdf"};
        IAtomContainer[] acs = null;
        try {
            acs = Misc.loadMolecules(fname, true, true, true);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] cnames = new String[]{"X", "Y", "Z", "A", "B", "C"};
        Object[][] dat = new Object[3][5];
        for (int i = 0; i < 3; ++i) {
            dat[i][0] = new Integer(i);
            dat[i][1] = new Double(i) / 3.4;
            dat[i][2] = "Hello " + i;
            dat[i][3] = "By " + i;
            dat[i][4] = 3;
        }
        ViewMolecule2DDataTable d = new ViewMolecule2DDataTable(acs, cnames, dat);
        d.display();
    }

    static class Render2DPanelCellRenderer
    extends JmolPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = 3990689120717795379L;

        Render2DPanelCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            return (Render2DPanel)value;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    static class Render2DPanelJTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1029080447213047474L;
        private Object[][] rows;
        private String[] columns;

        public Render2DPanelJTableModel(Object[][] objs, String[] cols) {
            this.rows = objs;
            this.columns = cols;
        }

        public String getColumnName(int column) {
            return this.columns[column];
        }

        public int getRowCount() {
            return this.rows.length;
        }

        public int getColumnCount() {
            return this.columns.length;
        }

        public Object getValueAt(int row, int column) {
            return this.rows[row][column];
        }

        public boolean isCellEditable(int row, int column) {
            return column == STRUCTURE_COL;
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }
    }

    static class Render2DColumnModelListener
    implements TableColumnModelListener {
        JTable table;

        public Render2DColumnModelListener(JTable t) {
            this.table = t;
        }

        public void columnAdded(TableColumnModelEvent e) {
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    class RowLabelRenderer
    extends DefaultTableCellRenderer {
        public RowLabelRenderer() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(1);
        }
    }

    class ApplicationCloser
    extends WindowAdapter {
        ApplicationCloser() {
        }

        public void windowClosing(WindowEvent e) {
            ViewMolecule2DDataTable.this.frame.dispose();
        }
    }
}

