/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.selection;

import java.awt.Color;
import java.util.Collection;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.selection.IChemObjectSelection;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class LogicalSelection
implements IChemObjectSelection {
    private Type type;
    private IChemModel chemModel;

    public LogicalSelection(Type type) {
        this.type = type;
    }

    public void clear() {
        this.type = Type.NONE;
        this.chemModel = null;
    }

    public IRenderingElement generate(Color color) {
        return null;
    }

    @Override
    public IAtomContainer getConnectedAtomContainer() {
        if (this.chemModel != null) {
            IAtomContainer ac = (IAtomContainer)this.chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            for (IAtomContainer other : ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel)) {
                ac.add(other);
            }
            return ac;
        }
        return null;
    }

    @Override
    public boolean isFilled() {
        return this.chemModel != null;
    }

    public boolean isFinished() {
        return true;
    }

    @Override
    public void select(IChemModel chemModel) {
        if (this.type == Type.ALL) {
            this.chemModel = chemModel;
        }
    }

    public void select(IAtomContainer atomContainer) {
        this.chemModel = (IChemModel)atomContainer.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IMoleculeSet molSet = (IMoleculeSet)atomContainer.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        molSet.addAtomContainer(atomContainer);
        this.chemModel.setMoleculeSet(molSet);
    }

    @Override
    public boolean contains(IChemObject obj) {
        if (this.type == Type.NONE) {
            return false;
        }
        for (IAtomContainer other : ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel)) {
            if (other == obj) {
                return true;
            }
            if (obj instanceof IBond && other.contains((IBond)obj)) {
                return true;
            }
            if (!(obj instanceof IAtom) || !other.contains((IAtom)obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <E extends IChemObject> Collection<E> elements(Class<E> clazz) {
        throw new UnsupportedOperationException();
    }

    public static enum Type {
        ALL,
        NONE;

    }
}

