/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class CholeskyDecomposition
implements Serializable {
    private double[][] L;
    private int n;
    private boolean isspd;

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix getL() {
        return new Matrix(this.L, this.n, this.n);
    }

    public Matrix solve(Matrix B) {
        int i;
        int j;
        if (B.getRowDimension() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] X = B.getArrayCopy();
        int nx = B.getColumnDimension();
        int k = 0;
        while (k < this.n) {
            j = 0;
            while (j < nx) {
                i = 0;
                while (i < k) {
                    double[] dArray = X[k];
                    int n = j;
                    dArray[n] = dArray[n] - X[i][j] * this.L[k][i];
                    ++i;
                }
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            j = 0;
            while (j < nx) {
                i = k + 1;
                while (i < this.n) {
                    double[] dArray = X[k];
                    int n = j;
                    dArray[n] = dArray[n] - X[i][j] * this.L[i][k];
                    ++i;
                }
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
            --k;
        }
        return new Matrix(X, this.n, nx);
    }

    public CholeskyDecomposition(Matrix Arg) {
        double[][] A = Arg.getArray();
        this.n = Arg.getRowDimension();
        this.L = new double[this.n][this.n];
        boolean bl = false;
        if (Arg.getColumnDimension() == this.n) {
            bl = true;
        }
        this.isspd = bl;
        int j = 0;
        while (j < this.n) {
            double[] Lrowj = this.L[j];
            double d = 0.0;
            int k = 0;
            while (k < j) {
                double[] Lrowk = this.L[k];
                double s = 0.0;
                int i = 0;
                while (i < k) {
                    s += Lrowk[i] * Lrowj[i];
                    ++i;
                }
                Lrowj[k] = s = (A[j][k] - s) / this.L[k][k];
                d += s * s;
                boolean bl2 = false;
                if (A[k][j] == A[j][k]) {
                    bl2 = true;
                }
                this.isspd &= bl2;
                ++k;
            }
            d = A[j][j] - d;
            boolean bl3 = false;
            if (d > 0.0) {
                bl3 = true;
            }
            this.isspd &= bl3;
            this.L[j][j] = Math.sqrt(Math.max(d, 0.0));
            k = j + 1;
            while (k < this.n) {
                this.L[j][k] = 0.0;
                ++k;
            }
            ++j;
        }
    }
}

