/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.gtk.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String URI_LIST = "text/uri-list";
    private static final int URI_LIST_ID = FileTransfer.registerType("text/uri-list");
    private static final byte[] separator = new byte[]{13, 10};

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] stringArray = (String[])object;
        byte[] byArray = new byte[]{};
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            if (string == null || (n = string.length()) == 0) continue;
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            long[] lArray = new long[1];
            long l = OS.g_utf16_to_utf8(cArray, cArray.length, null, null, lArray);
            if (lArray[0] != 0L || l == 0L) continue;
            long l2 = OS.g_filename_from_utf8(l, -1L, null, null, lArray);
            OS.g_free(l);
            if (lArray[0] != 0L || l2 == 0L) continue;
            long l3 = OS.g_filename_to_uri(l2, 0L, lArray);
            OS.g_free(l2);
            if (lArray[0] != 0L || l3 == 0L) continue;
            n = OS.strlen(l3);
            byte[] byArray2 = new byte[n];
            OS.memmove(byArray2, l3, (long)n);
            OS.g_free(l3);
            int n2 = i > 0 ? byArray.length + separator.length + byArray2.length : byArray2.length;
            byte[] byArray3 = new byte[n2];
            int n3 = 0;
            if (i > 0) {
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(separator, 0, byArray3, n3 += byArray.length, separator.length);
                n3 += separator.length;
            }
            System.arraycopy(byArray2, 0, byArray3, n3, byArray2.length);
            byArray = byArray3;
        }
        if (byArray.length == 0) {
            return;
        }
        long l = OS.g_malloc(byArray.length + 1);
        OS.memset(l, 0, byArray.length + 1);
        OS.memmove(l, byArray, (long)byArray.length);
        transferData.pValue = l;
        transferData.length = byArray.length;
        transferData.format = 8;
        transferData.result = 1;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        Object[] objectArray;
        int n;
        if (!this.isSupportedType(transferData) || transferData.pValue == 0L || transferData.length <= 0) {
            return null;
        }
        int n2 = transferData.length;
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, transferData.pValue, (long)n2);
        Object[] objectArray2 = new long[]{};
        int n3 = 0;
        for (n = 0; n < byArray.length - 1; ++n) {
            if (byArray[n] != 13 || byArray[n + 1] != 10) continue;
            int n4 = n - n3;
            long l = OS.g_malloc(n4 + 1);
            objectArray = new byte[n4 + 1];
            System.arraycopy(byArray, n3, objectArray, 0, n4);
            OS.memmove(l, objectArray, (long)(n4 + 1));
            long[] lArray = new long[objectArray2.length + 1];
            System.arraycopy(objectArray2, 0, lArray, 0, objectArray2.length);
            lArray[objectArray2.length] = l;
            objectArray2 = lArray;
            n3 = n + 2;
        }
        if (n3 < byArray.length - 2) {
            n = byArray.length - n3;
            long l = OS.g_malloc(n + 1);
            byte[] byArray2 = new byte[n + 1];
            System.arraycopy(byArray, n3, byArray2, 0, n);
            OS.memmove(l, byArray2, (long)(n + 1));
            objectArray = new long[objectArray2.length + 1];
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            objectArray[objectArray2.length] = (byte)l;
            objectArray2 = objectArray;
        }
        String[] stringArray = new String[]{};
        for (int i = 0; i < objectArray2.length; ++i) {
            long[] lArray = new long[1];
            long l = OS.g_filename_from_uri(objectArray2[i], null, lArray);
            OS.g_free(objectArray2[i]);
            if (lArray[0] != 0L || l == 0L) continue;
            long l2 = OS.g_filename_to_utf8(l, -1L, null, null, lArray);
            OS.g_free(l);
            if (lArray[0] != 0L || l2 == 0L) continue;
            long[] lArray2 = new long[1];
            long l3 = OS.g_utf8_to_utf16(l2, -1L, null, lArray2, null);
            OS.g_free(l2);
            n2 = (int)lArray2[0];
            char[] cArray = new char[n2];
            OS.memmove(cArray, l3, (long)(n2 * 2));
            OS.g_free(l3);
            String string = new String(cArray);
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            stringArray = stringArray2;
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{URI_LIST_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{URI_LIST};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && stringArray[i].length() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

