/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.elements;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;
import org.openscience.cdk.renderer.elements.TextElement;

public class TextGroupElement
extends TextElement {
    public final List<Child> children = new ArrayList<Child>();

    public TextGroupElement(double x, double y, String text, Color color) {
        super(x, y, text, color);
    }

    public void addChild(String text, Position position) {
        this.children.add(new Child(text, position));
    }

    public void addChild(String text, String subscript, Position position) {
        this.children.add(new Child(text, subscript, position));
    }

    @Override
    public void accept(IRenderingVisitor v) {
        v.visit(this);
    }

    public class Child {
        public final String text;
        public final String subscript;
        public final Position position;

        public Child(String text, Position position) {
            this.text = text;
            this.position = position;
            this.subscript = null;
        }

        public Child(String text, String subscript, Position position) {
            this.text = text;
            this.position = position;
            this.subscript = subscript;
        }
    }

    public static enum Position {
        NW,
        SW,
        SE,
        NE,
        S,
        N,
        W,
        E;

    }
}

