/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math;

import java.text.DecimalFormat;
import org.openscience.cdk.math.Complex;
import org.openscience.cdk.math.IVector;
import org.openscience.cdk.math.Matrix;

public class IMatrix {
    public double[][] realmatrix;
    public double[][] imagmatrix;
    public int rows;
    public int columns;

    public IMatrix(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.realmatrix = new double[rows][columns];
        this.imagmatrix = new double[rows][columns];
    }

    public IMatrix(Matrix m) {
        this.rows = m.rows;
        this.columns = m.columns;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.realmatrix[i][j] = m.matrix[i][j];
                this.imagmatrix[i][j] = 0.0;
            }
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public IVector getVectorFromRow(int index) {
        IVector result = new IVector(this.columns);
        for (int i = 0; i < this.columns; ++i) {
            result.realvector[i] = this.realmatrix[index][i];
            result.imagvector[i] = this.imagmatrix[index][i];
        }
        return result;
    }

    public IVector getVectorFromColumn(int index) {
        IVector result = new IVector(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            result.realvector[i] = this.realmatrix[i][index];
            result.imagvector[i] = this.imagmatrix[i][index];
        }
        return result;
    }

    public IVector getVectorFromDiagonal() {
        int size = Math.min(this.rows, this.columns);
        IVector result = new IVector(size);
        for (int i = 0; i < this.rows; ++i) {
            result.realvector[i] = this.realmatrix[i][i];
            result.imagvector[i] = this.imagmatrix[i][i];
        }
        return result;
    }

    public IMatrix add(IMatrix b) {
        IMatrix result = new IMatrix(this.rows, this.columns);
        this.add(b, result);
        return result;
    }

    public void add(IMatrix b, IMatrix result) {
        if (b == null || this.rows != b.rows || this.columns != b.columns) {
            return;
        }
        if (result.rows != this.rows || result.columns != this.columns) {
            result.reshape(this.rows, this.columns);
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.realmatrix[i][j] = this.realmatrix[i][j] + b.realmatrix[i][j];
                result.imagmatrix[i][j] = this.imagmatrix[i][j] + b.imagmatrix[i][j];
            }
        }
    }

    public IMatrix sub(IMatrix b) {
        IMatrix result = new IMatrix(this.rows, this.columns);
        this.sub(b, result);
        return result;
    }

    public void sub(IMatrix b, IMatrix result) {
        if (b == null || this.rows != b.rows || this.columns != b.columns) {
            return;
        }
        if (result.rows != this.rows || result.columns != this.columns) {
            result.reshape(this.rows, this.columns);
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.realmatrix[i][j] = this.realmatrix[i][j] - b.realmatrix[i][j];
                result.imagmatrix[i][j] = this.imagmatrix[i][j] - b.imagmatrix[i][j];
            }
        }
    }

    public IMatrix mul(IMatrix b) {
        IMatrix result = new IMatrix(this.rows, this.columns);
        this.mul(b, result);
        return result;
    }

    public void mul(IMatrix b, IMatrix result) {
        if (b == null || this.columns != b.rows) {
            return;
        }
        if (result.rows != this.rows || result.columns != b.columns) {
            result.reshape(this.rows, b.columns);
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int k = 0; k < b.columns; ++k) {
                double realsum = 0.0;
                double imagsum = 0.0;
                for (int j = 0; j < this.columns; ++j) {
                    realsum += this.realmatrix[i][j] * b.realmatrix[j][k] - this.imagmatrix[i][j] * b.imagmatrix[j][k];
                    imagsum += this.realmatrix[i][j] * b.imagmatrix[j][k] + this.imagmatrix[i][j] * b.realmatrix[j][k];
                }
                result.realmatrix[i][k] = realsum;
                result.imagmatrix[i][k] = imagsum;
            }
        }
    }

    public IVector mul(IVector a) {
        IVector result = new IVector(this.rows);
        this.mul(a, result);
        return result;
    }

    public void mul(IVector a, IVector result) {
        if (a == null || this.columns != a.size) {
            return;
        }
        if (result.size != this.rows) {
            result.reshape(this.rows);
        }
        for (int i = 0; i < this.rows; ++i) {
            double realsum = 0.0;
            double imagsum = 0.0;
            for (int j = 0; j < this.columns; ++j) {
                realsum += this.realmatrix[i][j] * a.realvector[j] - this.imagmatrix[i][j] * a.imagvector[j];
                imagsum += this.realmatrix[i][j] * a.imagvector[j] + this.imagmatrix[i][j] * a.realvector[j];
            }
            result.realvector[i] = realsum;
            result.imagvector[i] = imagsum;
        }
    }

    public IMatrix mul(Complex a) {
        IMatrix result = new IMatrix(this.rows, this.columns);
        this.mul(a, result);
        return result;
    }

    public void mul(Complex a, IMatrix result) {
        if (result.rows != this.rows || result.columns != this.columns) {
            result.reshape(this.rows, this.columns);
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.realmatrix[i][j] = this.realmatrix[i][j] * a.real - this.imagmatrix[i][j] * a.imag;
                result.imagmatrix[i][j] = this.realmatrix[i][j] * a.imag + this.imagmatrix[i][j] * a.real;
            }
        }
    }

    public IMatrix duplicate() {
        IMatrix result = new IMatrix(this.rows, this.columns);
        this.duplicate(result);
        return result;
    }

    public void duplicate(IMatrix result) {
        if (result.rows != this.rows || result.columns != this.columns) {
            result.reshape(this.rows, this.columns);
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.realmatrix[i][j] = this.realmatrix[i][j];
                result.imagmatrix[i][j] = this.imagmatrix[i][j];
            }
        }
    }

    public IMatrix transpose() {
        IMatrix result = new IMatrix(this.rows, this.columns);
        this.transpose(result);
        return result;
    }

    public void transpose(IMatrix result) {
        if (result.rows != this.rows || result.columns != this.columns) {
            result.reshape(this.rows, this.columns);
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.realmatrix[j][i] = this.realmatrix[i][j];
                result.imagmatrix[j][i] = this.imagmatrix[i][j];
            }
        }
    }

    public IMatrix similar(IMatrix U) {
        IMatrix result = new IMatrix(this.rows, this.columns);
        this.similar(U, result);
        return result;
    }

    public void similar(IMatrix U, IMatrix result) {
        if (result.rows != U.columns || result.columns != U.columns) {
            result.reshape(U.columns, U.columns);
        }
        for (int i = 0; i < U.columns; ++i) {
            for (int j = 0; j < U.columns; ++j) {
                double realsum = 0.0;
                double imagsum = 0.0;
                for (int k = 0; k < U.columns; ++k) {
                    double realinnersum = 0.0;
                    double imaginnersum = 0.0;
                    for (int l = 0; l < U.columns; ++l) {
                        realinnersum += this.realmatrix[k][l] * U.realmatrix[l][j] - this.imagmatrix[k][l] * U.imagmatrix[l][j];
                        imaginnersum += this.realmatrix[k][l] * U.imagmatrix[l][j] + this.imagmatrix[k][l] * U.realmatrix[l][j];
                    }
                    realsum += U.realmatrix[k][i] * realinnersum - U.imagmatrix[k][i] * imaginnersum;
                    imagsum += U.realmatrix[k][i] * imaginnersum + U.imagmatrix[k][i] * realinnersum;
                }
                result.realmatrix[i][j] = realsum;
                result.imagmatrix[i][j] = imagsum;
            }
        }
    }

    public Complex contraction() {
        Complex result = new Complex(0.0, 0.0);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.real += this.realmatrix[i][j];
                result.imag += this.imagmatrix[i][j];
            }
        }
        return result;
    }

    public String toString() {
        int j;
        if (this.rows <= 0 || this.columns <= 0) {
            return "[]";
        }
        DecimalFormat format = new DecimalFormat("00.0000");
        format.setPositivePrefix("+");
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.rows - 1; ++i) {
            for (j = 0; j < this.columns - 1; ++j) {
                if (Math.round(this.realmatrix[i][j] * 10000.0) != 0L && Math.round(this.imagmatrix[i][j] * 10000.0) != 0L) {
                    str.append(format.format(this.realmatrix[i][j]) + "+i*" + format.format(this.imagmatrix[i][j]) + " ");
                    continue;
                }
                str.append("--------+i*-------- ");
            }
            if (Math.round(this.realmatrix[i][this.columns - 1] * 10000.0) != 0L && Math.round(this.imagmatrix[i][this.columns - 1] * 10000.0) != 0L) {
                str.append(format.format(this.realmatrix[i][this.columns - 1]) + "+i*" + format.format(this.imagmatrix[i][this.columns - 1]) + "\n");
                continue;
            }
            str.append("--------+i*--------\n");
        }
        for (j = 0; j < this.columns - 1; ++j) {
            if (Math.round(this.realmatrix[this.rows - 1][j] * 10000.0) != 0L && Math.round(this.imagmatrix[this.rows - 1][j] * 10000.0) != 0L) {
                str.append(format.format(this.realmatrix[this.rows - 1][j]) + "+i*" + format.format(this.imagmatrix[this.rows - 1][j]) + " ");
                continue;
            }
            str.append("--------+i*-------- ");
        }
        if (Math.round(this.realmatrix[this.rows - 1][this.columns - 1] * 10000.0) != 0L && Math.round(this.imagmatrix[this.rows - 1][this.columns - 1] * 10000.0) != 0L) {
            str.append(format.format(this.realmatrix[this.rows - 1][this.columns - 1]) + "+i*" + format.format(this.imagmatrix[this.rows - 1][this.columns - 1]));
        } else {
            str.append("--------+i*-------- ");
        }
        return str.toString();
    }

    public void reshape(int newrows, int newcolumns) {
        int j;
        int i;
        if (newrows == this.rows && newcolumns == this.columns || newrows <= 0 || newcolumns <= 0) {
            return;
        }
        double[][] newrealmatrix = new double[newrows][newcolumns];
        double[][] newimagmatrix = new double[newrows][newcolumns];
        int minrows = Math.min(this.rows, newrows);
        int mincolumns = Math.min(this.columns, newcolumns);
        for (i = 0; i < minrows; ++i) {
            for (j = 0; j < mincolumns; ++j) {
                newrealmatrix[i][j] = this.realmatrix[i][j];
                newimagmatrix[i][j] = this.imagmatrix[i][j];
            }
        }
        for (i = minrows; i < newrows; ++i) {
            for (j = 0; j < mincolumns; ++j) {
                newrealmatrix[i][j] = 0.0;
                newimagmatrix[i][j] = 0.0;
            }
        }
        for (i = 0; i < minrows; ++i) {
            for (j = mincolumns; j < newcolumns; ++j) {
                newrealmatrix[i][j] = 0.0;
                newimagmatrix[i][j] = 0.0;
            }
        }
        for (i = minrows; i < newrows; ++i) {
            for (j = mincolumns; j < newcolumns; ++j) {
                newrealmatrix[i][j] = 0.0;
                newimagmatrix[i][j] = 0.0;
            }
        }
        this.realmatrix = newrealmatrix;
        this.imagmatrix = newimagmatrix;
        this.rows = newrows;
        this.columns = newcolumns;
    }
}

