/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.AbstractRenderer;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.IRenderer;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

public class AtomContainerRenderer
extends AbstractRenderer<IAtomContainer>
implements IRenderer<IAtomContainer> {
    public static final double DEFAULT_SCALE = 30.0;

    public AtomContainerRenderer(List<IGenerator<IAtomContainer>> generators, IFontManager fontManager) {
        this.generators = generators;
        this.fontManager = fontManager;
        for (IGenerator<IAtomContainer> generator : generators) {
            this.rendererModel.registerParameters(generator);
        }
    }

    @Override
    public void setup(IAtomContainer atomContainer, Rectangle screen) {
        this.setScale(atomContainer);
        Rectangle2D bounds = BoundsCalculator.calculateBounds(atomContainer);
        this.modelCenter = new Point2d(bounds.getCenterX(), bounds.getCenterY());
        this.drawCenter = new Point2d(screen.getCenterX(), screen.getCenterY());
        this.setup();
    }

    public void reset() {
        this.modelCenter = new Point2d(0.0, 0.0);
        this.drawCenter = new Point2d(200.0, 200.0);
        this.rendererModel.getParameter(BasicSceneGenerator.ZoomFactor.class).setValue(1.0);
        this.setup();
    }

    @Override
    public void setScale(IAtomContainer atomContainer) {
        double bondLength = GeometryTools.getBondLengthAverage((IAtomContainer)atomContainer);
        this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).setValue(this.calculateScaleForBondLength(bondLength));
    }

    @Override
    public Rectangle paint(IAtomContainer atomContainer, IDrawVisitor drawVisitor) {
        Rectangle2D modelBounds = BoundsCalculator.calculateBounds(atomContainer);
        this.setupTransformNatural(modelBounds);
        IRenderingElement diagram = this.generateDiagram(atomContainer);
        this.paint(drawVisitor, diagram);
        return this.convertToDiagramBounds(modelBounds);
    }

    @Override
    public void paint(IAtomContainer atomContainer, IDrawVisitor drawVisitor, Rectangle2D bounds, boolean resetCenter) {
        Rectangle2D modelBounds = BoundsCalculator.calculateBounds(atomContainer);
        this.setupTransformToFit(bounds, modelBounds, GeometryTools.getBondLengthAverage((IAtomContainer)atomContainer), resetCenter);
        IRenderingElement diagram = this.generateDiagram(atomContainer);
        this.paint(drawVisitor, diagram);
    }

    @Override
    public Rectangle calculateDiagramBounds(IAtomContainer atomContainer) {
        return this.calculateScreenBounds(BoundsCalculator.calculateBounds(atomContainer));
    }

    @Override
    public double calculateScaleForBondLength(double modelBondLength) {
        if (Double.isNaN(modelBondLength) || modelBondLength == 0.0) {
            return 30.0;
        }
        return (Double)this.rendererModel.getParameter(BasicBondGenerator.BondLength.class).getValue() / modelBondLength;
    }

    @Override
    public List<IGenerator<IAtomContainer>> getGenerators() {
        return new ArrayList<IGenerator<IAtomContainer>>(this.generators);
    }
}

